<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('coupons', function (Blueprint $table) {
            $table->id();
            $table->string('code')->unique(); // e.g., SAVE10, GIFT2025
            $table->string('type')->default('percentage'); // 'percentage' or 'fixed'
            $table->decimal('value', 10, 2); // discount amount or percentage value

            // Optional relationships
           
            $table->foreignId('product_id')->nullable()->constrained('products')->onDelete('cascade'); // specific product coupon
            $table->foreignId('category_id')->nullable()->constrained('categories')->onDelete('cascade'); // specific category

            // Usage rules
            $table->decimal('min_purchase', 10, 2)->nullable(); // minimum order amount to apply
            $table->integer('max_uses')->nullable(); // total number of times coupon can be used
            $table->integer('used_count')->default(0); // how many times used
            $table->integer('per_user_limit')->nullable(); // max times one user can use it

            // Validity
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->boolean('is_active')->default(true);

            // Meta
            $table->text('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('coupons');
    }
};
