<?php

namespace App\Services;

use App\Models\User;
use App\Notifications\SystemNotification;

class NotificationService
{
public static function send(
    int $userId,
    string $eventType,
     string $title,
    string $message,
    array $channels = ['dashboard'],
    $subject = null
) {
    if (!in_array('dashboard', $channels)) {
        return false;
    }

    $user = User::find($userId);
    if (!$user) {
        return false;
    }

    $user->notify(new SystemNotification(
        title: $title,
        message: $message,
        eventType: $eventType,
        subjectId: $subject->id ?? null,
        subjectType: $subject ? get_class($subject) : null
    ));

    return true;
}

}
