<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class UserAssignment extends Model
{
    protected $table = 'user_assignments';

    protected $fillable = [
        'user_id',
        'assigned_user_id',
    ];

    /* ======================
       Relationships
    ====================== */

    // User who assigns
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    // User who is assigned
    public function assignedUser()
    {
        return $this->belongsTo(User::class, 'assigned_user_id');
    }

    // Department context
    public function department()
    {
        return $this->belongsTo(Department::class);
    }
}
