<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;


class Location extends Model
{
  
    
    protected $fillable = [

        /* -----------------------------
         | Basic Info
         |-----------------------------*/
        'location_code',
        'name',
        'display_name',
        'type',

        /* -----------------------------
         | Address
         |-----------------------------*/
        'city',
        'district',
        'state',
        'country',
        'pincode',

        /* -----------------------------
         | Contact
         |-----------------------------*/
        'contact_person_name',
        'phone',
        'alternate_phone',
        'email',

        /* -----------------------------
         | Legal & Billing
         |-----------------------------*/
        'gst_number',
        'pan',
        'trade_license_no',
        'billing_name',
        'billing_address',

        /* -----------------------------
         | Reporting / Status
         |-----------------------------*/
        'reporting_location_id',
        'status',

        /* -----------------------------
         | Audit
         |-----------------------------*/
        'created_by',
        'updated_by',
    ];
    protected $guarded = [];

    // ✅ ADD THIS
    public function stocks()
    {
        return $this->hasMany(Stock::class, 'location_id');
    }

    public function reportingLocation()
    {
        return $this->belongsTo(Location::class, 'reporting_location_id');
    }

    public function scopeActive($query)
    {
        return $query->where('status', 'Active');
    }
}
