<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CartItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'cart_id',
        'product_id',
        'variant_id',
        'price',
        'quantity',
        'subtotal'
    ];

    /* Relationships */

    public function cart()
    {
        return $this->belongsTo(Cart::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function variant()
    {
        return $this->belongsTo(ProductVariant::class, 'variant_id');
    }

    /* Auto calculate subtotal */

    protected static function booted()
    {
        static::saving(function ($item) {
            $item->subtotal = $item->price * $item->quantity;
        });
    }

      /* Helpers */

    public function getSubtotalAttribute()
    {
        return $this->quantity * $this->price;
    }
}
