<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Brands extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'image',
    ];

    // Append full image URL
    protected $appends = ['image_full'];

    // Hide raw image path
    protected $hidden = ['image', 'pivot'];

    protected $casts = [
        'image_full' => 'string',
    ];

    /**
     * Get full image URL
     */
    public function getImageFullAttribute()
    {
        if ($this->image) {
            return asset($this->image);
        }

        return asset('assets/images/default-brand.JPG');
    }
}
