<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Banner extends Model
{
    protected $fillable = [

        // Basic
        'title',
        'image',

        // Banner Type / Placement
        'banner_type',
        'placement',

        // Visibility
        'audience',
        'platform',

        // Relations
        'category_id',
        'product_id',

        // Sorting / Priority
        'priority',
        'auto_sort',

        // Schedule
        'start_date',
        'end_date',

        // Analytics
        'views',
        'clicks',

        // Status
        'status',
    ];

    protected $casts = [
        'auto_sort' => 'boolean',
        'status'    => 'boolean',
        'start_date' => 'date',
        'end_date'  => 'date',
    ];

    protected $appends = ['image_url'];
    protected $hidden = ['image'];
    public function getImageUrlAttribute()
    {
        if (!$this->image) {
            return null;
        }

        if (str_starts_with($this->image, 'http')) {
            return $this->image;
        }

        return url($this->image);
    }

    // ✅ Relationship to Category
    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }
}
