<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ActivityLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'causer_id',
        'event_type',
        'description',
        'subject_type',
        'subject_id',
        'changes',
    ];

    protected $casts = [
        'changes' => 'array',
    ];

    // Who performed the action
    public function causer()
    {
        return $this->belongsTo(User::class, 'causer_id');
    }

    // Polymorphic subject (User, Product, Banner, etc.)
    public function subject()
    {
        return $this->morphTo();
    }
}
