<?php

// app/Listeners/LogUserLogout.php
namespace App\Listeners;

use Illuminate\Auth\Events\Logout;
use App\Models\LoginActivity;

class LogUserLogout
{
    public function handle(Logout $event): void
    {
        LoginActivity::where('user_id', $event->user->id)
            ->whereNull('logout_at')
            ->latest()
            ->first()
            ?->update([
                'logout_at' => now(),
            ]);
    }
}
