<?php

// app/Listeners/LogUserLogin.php
namespace App\Listeners;

use Illuminate\Auth\Events\Login;
use App\Models\LoginActivity;

class LogUserLogin
{
    public function handle(Login $event): void
    {
        LoginActivity::create([
            'user_id' => $event->user->id,
            'login_at' => now(),
            'device' => request()->userAgent(),
            'ip_address' => request()->ip(),
        ]);
    }
}
