<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Room;
use App\Models\Tags;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\File;

class SettingsController extends Controller
{
    public function addRoom(Request $request)
    {
        try {
            $request->validate([
                'name'       => 'required|string|max:255',
                'photo'      => 'nullable|image|mimes:jpg,jpeg,png,webp,avif|max:4096',
            ]);

            $imagePath = null;

            if ($request->hasFile('photo')) {
                $image = $request->photo;
                $imageName = time() . '-' . rand(100, 999) . '.' . $image->extension();
                $uploadPath = public_path('assets/upload/room/');

                if (!File::exists($uploadPath)) {
                    File::makeDirectory($uploadPath, 0755, true);
                }

                $image->move($uploadPath, $imageName);
                $imagePath = 'assets/upload/room/' . $imageName;
            }
            $res = Room::insert([
                'name' => $request->input('name'),
                'image' => $imagePath,
            ]);

            return response()->json(['success' => 'Room added successfully.']);
        } catch (\Illuminate\Validation\ValidationException $e) {

            return response()->json([
                'status' => false,
                'errors' => $e->errors(),
                'message' => 'Validation failed'
            ], 422);
        } catch (\Exception $e) {

            return response()->json([
                'status'  => false,
                'message' => $e->getMessage()
            ], 500);
        }
    }

    public function getRoom()
    {
        $users = Room::orderBy('id', 'DESC')->get();

        return DataTables::of($users)
            ->addIndexColumn()
            ->addColumn('name', function ($data) {
                return   $data->name;
            })
            ->addColumn('image', function ($data) {
                return '<img src="' . asset($data->image) . '" class="avatar-md">';
            })
            ->addColumn('action', function ($row) {
                return '<a href="" class="btn btn-sm btn-purple editroom" data-id="' . $row->id . '">Edit</a>
                <a href="" class="btn btn-sm btn-danger deleteroom" data-id="' . $row->id . '">Delete</a>';
            })
            ->escapeColumns([])
            ->make(true);
    }


    // Delete Room (AJAX)
    public function destroy($id)
    {
        $Room = Room::findOrFail($id);
        $Room->delete();
        return response()->json(['success' => 'Room deleted successfully.']);
    }

    public function update(Request $request, $id)
    {
        try {
            $request->validate([
                'name' => 'required|string|max:100',
                'photo'      => 'nullable|image|mimes:jpg,jpeg,png,webp,avif|max:4096',

            ]);
            // Image upload
            if ($request->hasFile('photo')) {
                $image = $request->file('photo');
                $imageName = time() . '-' . rand(100, 999) . '.' . $image->extension();
                $uploadPath = public_path('assets/upload/category/');

                if (!File::exists($uploadPath)) {
                    File::makeDirectory($uploadPath, 0755, true);
                }

                $image->move($uploadPath, $imageName);
                Room::where('id', $id)->update([
                    'image' =>  'assets/upload/category/' . $imageName,
                ]);
            }

            //$Room = Room::findOrFail($id);
            Room::where('id', $id)->update([
                'name' => $request->name,
            ]);

            return response()->json(['success' => 'Room updated successfully.']);
        } catch (\Illuminate\Validation\ValidationException $e) {

            return response()->json([
                'status' => false,
                'errors' => $e->errors(),
                'message' => 'Validation failed'
            ], 422);
        } catch (\Exception $e) {

            return response()->json([
                'status'  => false,
                'message' => $e->getMessage()
            ], 500);
        }
    }


    //**tags *************/

    public function addtag(Request $request)
    {
        $res = Tags::insert([
            'name' => $request->input('name')
        ]);


        if ($res == 1)
            return redirect()->back()->with('success', 'tag added successfully');
        else
            return redirect()->back()->with('error', 'Something went wrong');
    }

    public function gettag()
    {
        $users = Tags::orderBy('id', 'DESC')->get();

        return DataTables::of($users)
            ->addIndexColumn()
            ->addColumn('name', function ($data) {
                return   $data->name;
            })

            ->addColumn('action', function ($row) {
                return '<a href="" class="btn btn-sm btn-purple edittag" data-id="' . $row->id . '">Edit</a>
                <a href="" class="btn btn-sm btn-danger deletetag" data-id="' . $row->id . '">Delete</a>';
            })
            ->escapeColumns([])
            ->make(true);
    }


    // Delete tag (AJAX)
    public function destroytag($id)
    {
        $tag = Tags::findOrFail($id);
        $tag->delete();
        return response()->json(['success' => 'tag deleted successfully.']);
    }

    public function updatetag(Request $request, $id)
    {
        $request->validate([
            'name' => 'required|string|max:100',
        ]);

        //$tag = Tags::findOrFail($id);
        Tags::where('id', $id)->update([
            'name' => $request->name,
        ]);

        return response()->json(['success' => 'tag updated successfully.']);
    }
}
