<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Cache;
use App\Models\Cart;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Carbon;
  use App\Services\FirebaseService;
use Kreait\Firebase\Exception\Auth\FailedToVerifyToken;

class LoginController extends Controller
{

public function testlogin(Request $request)
{
    $request->validate([
        'phone' => 'required|string'
    ]);

    // ✅ Find user by phone
    $user = User::where('phone', $request->phone)->first();

    if (!$user) {
        return response()->json([
            'success' => false,
            'message' => 'User not found with this phone number'
        ], 404);
    }

    // ✅ Delete old tokens (optional, dev-friendly)
    $user->tokens()->delete();

    // ✅ Create sanctum token
    $token = $user->createToken('dev-login')->plainTextToken;

    return response()->json([
        'success' => true,
        'message' => 'Login successful',
        'token'   => $token,
        'user'    => [
            'id'    => $user->id,
            'name'  => $user->name,
            'phone' => $user->phone,
        ]
    ]);
}
public function login(Request $request, FirebaseService $firebase)
{
    $request->validate([
        'firebase_token' => 'required|string',
    ]);

    try {
        $verifiedToken = $firebase->verifyIdToken($request->firebase_token);
        $firebaseUid = $verifiedToken->claims()->get('sub');
        $phone = $verifiedToken->claims()->get('phone_number');

    } catch (FailedToVerifyToken $e) {
        return response()->json([
            'status' => false,
            'message' => 'Invalid Firebase token',
        ], 401);
    }

    $user = User::firstOrCreate(
        ['phone' => $phone],
        [
            'user_type' => 'customer',
            'status' => 'Active',
        ]
    );

    $user->tokens()->delete();

    $token = $user->createToken('mobile-login')->plainTextToken;

    $isProfileComplete = !empty($user->name) && !empty($user->email);

    $user->update(['last_login_at' => now()]);

    return response()->json([
        'status' => true,
        'message' => 'Login successful',
        'token' => $token,
        'is_new_user' => !$isProfileComplete,
        'next_screen' => $isProfileComplete ? 'home' : 'profile',
        'user' => [
            'id' => $user->id,
            'phone' => $user->phone,
            'user_type' => $user->user_type,
        ]
    ]);
}

    public function updateProfile(Request $request)
    {
        $request->validate([
            'name'  => 'required|string|max:255',
            'email' => 'required|email|unique:users,email,' . auth()->id()
        ]);

        $user = auth()->user();

        $user->update([
            'name'  => $request->name,
            'email' => $request->email,
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Profile updated successfully',
            'next_screen' => 'home'
        ]);
    }

     public function updatefullProfile(Request $request)
    {
        $request->validate([
            'name'  => 'required|string|max:255',
            'email' => 'required|email|unique:users,email,' . auth()->id(),
            'phone' => 'required|string|max:255',
            'photo'      => 'nullable|image|mimes:jpg,jpeg,png|max:4096',
        ]);

        $user = auth()->user();

        $user->update([
            'name'  => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
        ]);
  $image = '';

            if ($request->photo) {
                $rand = rand(100, 999);
                $image = time() . '.' . $request->photo->extension();
                $imageOriginalName = $request->photo->getClientOriginalName();
                $request->photo->move(public_path('assets/upload/users/'), $image);
                User::where('id', auth()->user()->id)
                    ->update([
                        'profile_image' => $image,
                    ]);
            }
        return response()->json([
            'status' => true,
            'message' => 'Profile updated successfully',
        ]);
    }

    public function logout(Request $request)
    {
        // Delete only the current token
        $request->user()->currentAccessToken()->delete();

        return response()->json([
            'status' => true,
            'message' => 'Logged out successfully'
        ]);
    }
}
