<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Cart;
use App\Models\ProductVariant;
use App\Models\CartItem;
use Illuminate\Support\Facades\Auth;

class CartController extends Controller
{
    // public function addToCart(Request $request)
    // {
    //     $userId = auth()->id();

    //     $request->validate([
    //         'product_id' => 'required|exists:products,id',
    //         'variant_id' => 'required|exists:product_variants,id',
    //         'quantity'   => 'required|integer|min:1',
    //     ]);

    //     $variant = ProductVariant::where('id', $request->variant_id)
    //         ->where('product_id', $request->product_id)
    //         ->with('stocks') // ✅ load all stocks
    //         ->firstOrFail();

    //     // ✅ Calculate usable stock across locations
    //     $availableQty = $variant->stocks
    //         ->where('is_available', 1)
    //         ->sum(function ($stock) {
    //             return max(
    //                 ($stock->available_qty ?? 0) - ($stock->reserved_qty ?? 0),
    //                 0
    //             );
    //         });

    //     if ($availableQty <= 0) {
    //         return response()->json([
    //             'success' => false,
    //             'message' => 'Product out of stock'
    //         ], 400);
    //     }

    //     if ($request->quantity > $availableQty) {
    //         return response()->json([
    //             'success' => false,
    //             'message' => 'Quantity exceeds available stock'
    //         ], 400);
    //     }

    //     $cart = Cart::firstOrCreate([
    //         'user_id' => $userId
    //     ]);

    //     $cartItem = CartItem::where([
    //         'cart_id'    => $cart->id,
    //         'variant_id' => $variant->id
    //     ])->first();

    //     if ($cartItem) {
    //         $cartItem->quantity += $request->quantity;
    //     } else {
    //         $cartItem = new CartItem();
    //         $cartItem->cart_id    = $cart->id;
    //         $cartItem->product_id = $request->product_id;
    //         $cartItem->variant_id = $variant->id;
    //         $cartItem->price      = $variant->offer_price;
    //         $cartItem->quantity   = $request->quantity;
    //     }

    //     // ✅ Re-check after increment
    //     if ($cartItem->quantity > $availableQty) {
    //         return response()->json([
    //             'success' => false,
    //             'message' => 'Quantity exceeds available stock'
    //         ], 400);
    //     }

    //     $cartItem->subtotal = $cartItem->price * $cartItem->quantity;
    //     $cartItem->save();

    //     return response()->json([
    //         'success'     => true,
    //         'message'     => 'Product added to cart',
    //         'cart_count'  => $cart->items()->sum('quantity')
    //     ]);
    // }

    // public function updateQuantity(Request $request)
    // {
    //     $request->validate([
    //         'cart_item_id' => 'required|exists:cart_items,id',
    //         'quantity'     => 'required|integer|min:1'
    //     ]);

    //     $cartItem = CartItem::where('id', $request->cart_item_id)
    //         ->whereHas(
    //             'cart',
    //             fn($q) =>
    //             $q->where('user_id', auth()->id())
    //         )
    //         ->with('variant.stocks')
    //         ->firstOrFail();

    //     $variant = $cartItem->variant;

    //     // ✅ Sum usable stock across all locations
    //     $availableQty = $variant->stocks
    //         ->where('is_available', 1)
    //         ->sum(function ($stock) {
    //             return max(
    //                 ($stock->available_qty ?? 0) - ($stock->reserved_qty ?? 0),
    //                 0
    //             );
    //         });

    //     if ($availableQty <= 0) {
    //         return response()->json([
    //             'success' => false,
    //             'message' => 'Product out of stock'
    //         ], 400);
    //     }

    //     if ($request->quantity > $availableQty) {
    //         return response()->json([
    //             'success' => false,
    //             'message' => 'Quantity exceeds available stock'
    //         ], 400);
    //     }

    //     $cartItem->quantity = $request->quantity;
    //     $cartItem->save();

    //     return response()->json([
    //         'success'  => true,
    //         'message'  => 'Quantity updated',
    //         'subtotal' => (float) $cartItem->subtotal
    //     ]);
    // }
    public function addToCart(Request $request)
{
    $userId = auth()->id();

    $request->validate([
        'product_id' => 'required|exists:products,id',
        'variant_id' => 'required|exists:product_variants,id',
        'quantity'   => 'required|integer|min:1',
    ]);

    $variant = ProductVariant::where('id', $request->variant_id)
        ->where('product_id', $request->product_id)
        ->firstOrFail();

    $cart = Cart::firstOrCreate([
        'user_id' => $userId
    ]);

    $cartItem = CartItem::where([
        'cart_id'    => $cart->id,
        'variant_id' => $variant->id
    ])->first();

    if ($cartItem) {
        $cartItem->quantity += $request->quantity;
    } else {
        $cartItem = new CartItem();
        $cartItem->cart_id    = $cart->id;
        $cartItem->product_id = $request->product_id;
        $cartItem->variant_id = $variant->id;
        $cartItem->price      = $variant->offer_price;
        $cartItem->quantity   = $request->quantity;
    }

    $cartItem->subtotal = $cartItem->price * $cartItem->quantity;
    $cartItem->save();

    return response()->json([
        'success'    => true,
        'message'    => 'Product added to cart',
        'cart_count' => $cart->items()->sum('quantity')
    ]);
}
public function updateQuantity(Request $request)
{
    $request->validate([
        'cart_item_id' => 'required|exists:cart_items,id',
        'quantity'     => 'required|integer|min:1'
    ]);

    $cartItem = CartItem::where('id', $request->cart_item_id)
        ->whereHas('cart', function ($q) {
            $q->where('user_id', auth()->id());
        })
        ->firstOrFail();

    $cartItem->quantity = $request->quantity;
    $cartItem->subtotal = $cartItem->price * $request->quantity;
    $cartItem->save();

    return response()->json([
        'success'  => true,
        'message'  => 'Quantity updated',
        'subtotal' => (float) $cartItem->subtotal
    ]);
}

    public function index()
    {
        $cart = Cart::with([
            'items.product:id,name',
            'items.variant.images'
        ])->where('user_id', auth()->id())->first();

        if (!$cart || $cart->items->isEmpty()) {
            return response()->json([
                'success' => true,
                'data' => [
                    'items' => [],
                    'price_details' => [
                        'delivery_fee' => 0,
                        'discount' => 0,
                        'total' => 0
                    ]
                ]
            ]);
        }

        $items = $cart->items->map(function ($item) {
            return [
                'cart_item_id' => $item->id,
                'product_id'   => $item->product_id,
                'name'         => $item->product->name,
                'variant' => [
                    'variant_id' => $item->variant_id,
                    'color'      => $item->variant->color_name ?? null,
                    'image'      => optional(
                        $item->variant->images->firstWhere('is_primary', 1)
                    )->image
                ],
                'price'    => (float) $item->price,
                'quantity' => $item->quantity,
                'subtotal' => (float) $item->subtotal
            ];
        });

        $subtotal = $cart->items->sum('subtotal');
        $deliveryFee = 25;
        $discount = 35;

        return response()->json([
            'success' => true,
            'data' => [
                'items' => $items,
                'price_details' => [
                    'delivery_fee' => $deliveryFee,
                    'discount'     => $discount,
                    'total'        => max(0, $subtotal + $deliveryFee - $discount)
                ]
            ]
        ]);
    }


    public function remove($cartItemId)
    {
        $cartItem = CartItem::where('id', $cartItemId)
            ->whereHas(
                'cart',
                fn($q) =>
                $q->where('user_id', auth()->id())
            )->firstOrFail();

        $cartItem->delete();

        return response()->json([
            'success' => true,
            'message' => 'Item removed from cart'
        ]);
    }
}
