<?php

namespace App\Events;

use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class SystemEvent
{
    use Dispatchable, SerializesModels;

    public string $eventType;
    public ?object $subject;
    public string $message;
    public ?int $recipientId;
    public array $channels;
    public array $changes;
    public ?string $title;

    public function __construct(array $data)
    {
        $this->eventType   = $data['event_type'] ?? $data['type'] ?? 'system';
        $this->title       = $data['title'] ?? 'System Alert';
        $this->subject     = $data['subject'] ?? null;
        $this->message     = $data['message'] ?? '';
        $this->recipientId = $data['recipient_id'] ?? null;
        $this->channels    = $data['channels'] ?? ['dashboard'];
        $this->changes     = $data['changes'] ?? [];
    }
}
