<?php
// use Illuminate\Auth\Middleware\Authenticate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\HomeController;
use App\Http\Controllers\Api\LoginController;
use App\Http\Controllers\Api\CartController;
use App\Http\Controllers\Api\ProductController;
use App\Http\Controllers\Api\OrderController;
use App\Http\Controllers\Api\WishlistController;
use App\Http\Controllers\Api\WholesaleEnquiryController;
use App\Http\Controllers\Api\FaqController;
use App\Http\Controllers\Api\ProjectController;
use App\Http\Controllers\Api\NotificationController;
use App\Http\Controllers\Api\PdfController;
// Guest Cart



Route::post('/login', [LoginController::class, 'login']);

Route::post('/test/login', [LoginController::class, 'testlogin']);
Route::get('privacy-policy', [FaqController::class, 'privacyPolicy']);
Route::get('terms-conditions', [FaqController::class, 'termsConditions']);
Route::get('/pdf/measurement/{id}', [PdfController::class, 'measurement']);
Route::get('/pdf/quotation/{id}', [PdfController::class, 'quotation']);
Route::get('/pdf/invoice/{id}', [PdfController::class, 'invoice']);
// After Login (Secure Routes)
Route::middleware(['auth:sanctum'])->group(function () {
    Route::post('/wishlist/add', [WishlistController::class, 'add']);
    Route::delete('/wishlist/remove', [WishlistController::class, 'remove']);
    Route::get('/wishlist', [WishlistController::class, 'list']);
    Route::get('/flash-sale/products/{tagId?}', [HomeController::class, 'productsByTagFull']);
    Route::get('special-for-you', [HomeController::class, 'specialForYouFull']);
    Route::get('/banners', [HomeController::class, 'banners']);
    Route::post('/banner/{id}/view', [HomeController::class, 'bannerView']);
    Route::post('/banner/{id}/click', [HomeController::class, 'bannerClick']);
    Route::prefix('home')->group(function () {
        Route::get('/flash-sale/tags', [HomeController::class, 'tags']);
        Route::get('/flash-sale/products/{tagId?}', [HomeController::class, 'productsByTag']);


        Route::get('special-for-you', [HomeController::class, 'specialForYou']);
        Route::get('explore-luxury-curtains', [HomeController::class, 'exploreLuxuryCurtains']);
        Route::get('brands', [HomeController::class, 'brands']);
        Route::get('best-seller/categories', [HomeController::class, 'bestSellerCategories']);
        Route::get('best-seller/products/{category_id}', [HomeController::class, 'bestSellerProducts']);
        Route::get('/search', [HomeController::class, 'search']);
        Route::get('/categories', [HomeController::class, 'categories']);
        Route::get('/video', [HomeController::class, 'homeVideo']);
        Route::get('/explore', [HomeController::class, 'homeExplore']);
    });


    Route::post('/products', [ProductController::class, 'listing']);
    Route::get('/products/{id}', [ProductController::class, 'show']);

    Route::get('/profile', function () {

        $user = auth()->user();

        return response()->json([
            'status' => true,
            'data' => array_merge(
                $user->toArray(),
                [
                    'role' => optional($user->role)->name
                ]
            )
        ]);
    });


    Route::post('/profile/update', [LoginController::class, 'updateProfile']);
    Route::post('/profile/full/update', [LoginController::class, 'updatefullProfile']);
    Route::post('/logout', [LoginController::class, 'logout']);
    Route::post('/add/staff', [LoginController::class, 'storeStaff']);

    Route::get('/user/addresses', [LoginController::class, 'index']);
    Route::post('/add/user/addresses', [LoginController::class, 'store']);
    Route::post('/update/user/addresses/{id}', [LoginController::class, 'update']);
    Route::delete('/user/addresses/{id}', [LoginController::class, 'destroy']);

    Route::post('/setas/defualt/addresses', [LoginController::class, 'setasDefaultaddress']);
    Route::get('/defualt/user/addresses', [LoginController::class, 'defaultaddress']);

    Route::get('/rooms', [ProductController::class, 'rooms']);
    Route::get('/categories', [ProductController::class, 'categories']);
    Route::get('/subcategories', [ProductController::class, 'subcategories']);

    Route::post('/calculate', [ProductController::class, 'calculate']);
    //cart
    Route::post('/cart/add', [CartController::class, 'addToCart']);
    Route::post('/cart/update-quantity', [CartController::class, 'updateQuantity']);
    Route::get('/cart', [CartController::class, 'index']);
    Route::delete('/cart/remove/{cartItemId}', [CartController::class, 'remove']);

    // Step 1: Create order (before payment)
    Route::post('/orders/create', [OrderController::class, 'createOrder']);

    // Step 2: Place order (after payment success)
    Route::post('/orders/place', [OrderController::class, 'placeOrder']);
    Route::get('/couriers', [OrderController::class, 'courierlist']);

    // My Orders
    Route::get('/orders', [OrderController::class, 'myOrders']);
    // Order Details
    Route::post('cancel-order', [OrderController::class, 'cancelOrder']);
    Route::post('/order/return', [OrderController::class, 'returnOrder']);
    Route::get('/orders/{id}', [OrderController::class, 'orderDetails']);

    Route::post('project/create-order', [OrderController::class, 'createOrderFromProject']);
    Route::post('razorpay/payment-success', [OrderController::class, 'paymentSuccess']);


    Route::post('/add/reviews', [ProductController::class, 'storereview']);
    Route::get('/products/{product}/reviews', [ProductController::class, 'productReviews']);
    Route::get('/coupons', [ProductController::class, 'couponList']);
    Route::post('/applyCoupon', [CartController::class, 'applyCoupon']);
    Route::post('/removeCoupon', [CartController::class, 'removeCoupon']); // remove

    Route::post('wholesale-enquiry', [WholesaleEnquiryController::class, 'store']);
    Route::get('faqs', [FaqController::class, 'index']);
    Route::get('contact-us', [FaqController::class, 'contactsetting']);

    Route::post(
        'account/delete-request',
        [FaqController::class, 'requestDeleteAccount']
    );


    Route::post('change-role', [LoginController::class, 'upgradeAccount']);

    // project

    Route::prefix('project')->group(function () {
        Route::post('/add', [ProjectController::class, 'store']);
        Route::post('/edit', [ProjectController::class, 'editProject']);

        Route::post(
            '/areas/items',
            [ProjectController::class, 'storeProjectItem']
        );
        Route::post(
            '/add/area',
            [ProjectController::class, 'storeProjectArea']
        );
        Route::get('/show', [ProjectController::class, 'show']);
        Route::get('/list', [ProjectController::class, 'index']);
        Route::delete('/delete/{project}', [ProjectController::class, 'destroy']);
        Route::delete('/delete/area/{area}', [ProjectController::class, 'destroyArea']);
        Route::delete('/delete/item/{item}', [ProjectController::class, 'destroyItem']);

        Route::get(
            '/config/category/{id}',
            [ProjectController::class, 'getCategoryData']
        );

        Route::get(
            '/config/subcategory/{id}',
            [ProjectController::class, 'getSubcategoryCatalogues']
        );
        Route::get(
            '/get/item',
            [ProjectController::class, 'getProjectItems']
        );

        Route::post(
            '/config/catalogue-skus',
            [ProjectController::class, 'getCatalogueSkus']
        );
        Route::post('/add/custom-item', [ProjectController::class, 'storeCustomItem']);
        Route::get('/custom-item/{id}', [ProjectController::class, 'getCustomItem']);

        Route::post('/custom-calculate', [ProjectController::class, 'calculate']);
    });


Route::get('/my/quotations', [ProjectController::class, 'myquotations']);
Route::get('/my/quotations/download', [ProjectController::class, 'download']);
 
    Route::get('/notifications', [NotificationController::class, 'index']);
    Route::post('/notifications/read/{id}', [NotificationController::class, 'markAsRead']);
    Route::post('/notifications/read-all', [NotificationController::class, 'markAllRead']);
    Route::delete('/notifications/{id}', [NotificationController::class, 'delete']);
    Route::delete('/notifications', [NotificationController::class, 'deleteAll']);
});
