@extends('pdf.layouts.interior')

@section('title','Premium Quotation')

@section('content')

<div class="section-title">Room Wise Quotation</div>

@foreach($project->areas as $area)

<h4>{{ $area->area_name }}</h4>

<table>
    <thead>
        <tr>
            <th>Img</th>
            <th>Item</th>
            <!-- <th>Fabric</th> -->
            <th>Size</th>
            <th>Qty</th>
            <th>Rate</th>
            <th>Total</th>
        </tr>
    </thead>

    <tbody>

        @foreach($area->items as $item)

        <tr>

            <td>
                @if($item->variant && $item->variant->primaryImage)
                <img src="{{ public_path($item->variant->primaryImage->image_path) }}" class="product-img" wisth="50" height="50">
                @endif

            </td>

            <td>{{ ucfirst($item->category) }}</td>

            <!-- <td>
                @if($item->fabric_image)
                <img src="{{asset($item->fabric_image)}}" class="swatch">
                @endif
            </td> -->

            <td>
                @if($item->measurement)
                {{ $item->measurement->width }}
                x
                {{ $item->measurement->height }}
                @else
                -
                @endif

            </td>

            @if($item->is_custom == 0)

            @if($item->category == 'curtain')
            <td>{{ $item->quantity }} pcs</td>
            @elseif($item->category == 'wallpaper')
            <td>{{ $item->quantity }} rolls</td>
            @else
            <td>{{ $item->quantity }}</td>
            @endif

            @elseif($item->category == 'curtain' && $item->curtain && $item->measurement)

            @php
            $fw = (float) $item->curtain->fabric_width;
            $ww = (float) $item->measurement->width;
            $wh = (float) $item->measurement->height;

            $qty = ($fw > 0) ? ceil($ww / $fw) * $wh : 0;
            @endphp

            <td>{{ $qty > 0 ? number_format($qty,2).' m' : '-' }}</td>

            @elseif($item->category == 'wallpaper' && $item->wallpaper)

            @php
            $rw = (float) $item->wallpaper->roll_width;
            $rl = (float) $item->wallpaper->roll_length;
            $ww = (float) $item->wallpaper->wall_width;
            $wh = (float) $item->wallpaper->wall_height;
            $rep = (float) ($item->wallpaper->design_repeat ?? 0);

            $cuttings = ($rw > 0) ? ceil($ww / $rw) : 0;
            $qty = ($rl > 0) ? ceil(($cuttings * ($wh + $rep)) / $rl) : 0;
            @endphp

            <td>{{ $qty > 0 ? $qty.' rolls' : '-' }}</td>

            @else

            <td>-</td>

            @endif


            @php
            $price = 0.0;
            $total = 0.0;

            if ($item->is_custom == 0) {

            $price = (float) ($item->variant?->offer_price ?? 0);
            $qty = (int) ($item->quantity ?? 1);
            $total = $price * $qty;

            } else {

            // 🟢 CUSTOM CURTAIN
            if ($item->category === 'curtain' && $item->curtain && $item->measurement) {

            $fabricWidth = (float) $item->curtain->fabric_width;
            $pricePerMeter = (float) $item->curtain->price_per_meter;

            $wallWidth = (float) $item->measurement->width;
            $wallHeight = (float) $item->measurement->height;

            if ($fabricWidth > 0 && $wallWidth > 0 && $wallHeight > 0) {
            $panels = ceil($wallWidth / $fabricWidth);
            $fabricRequired = $panels * $wallHeight;

            $price = $pricePerMeter;
            $total = $fabricRequired * $pricePerMeter;
            }
            }

            // 🟢 CUSTOM WALLPAPER
            if ($item->category === 'wallpaper' && $item->wallpaper) {

            $rollWidth = (float) $item->wallpaper->roll_width;
            $rollLength = (float) $item->wallpaper->roll_length;
            $pricePerRoll = (float) $item->wallpaper->price_per_roll;

            $wallWidth = (float) $item->wallpaper->wall_width;
            $wallHeight = (float) $item->wallpaper->wall_height;
            $repeat = (float) ($item->wallpaper->design_repeat ?? 0);

            if ($rollWidth > 0 && $rollLength > 0) {
            $cuttings = ceil($wallWidth / $rollWidth);
            $cuttingHeight = $wallHeight + $repeat;
            $totalLength = $cuttings * $cuttingHeight;
            $rolls = ceil($totalLength / $rollLength);

            $price = $pricePerRoll;
            $total = $rolls * $pricePerRoll;
            }
            }
            }
            @endphp

            <td>{{ $price > 0 ? number_format($price, 2) : '-' }}</td>
            <td>{{ $total > 0 ? number_format($total, 2) : '-' }}</td>

        </tr>

        @endforeach

    </tbody>
</table>

@endforeach

<div class="total-box text-right">
    Subtotal : {{ number_format($project->subtotal,2) }} <br>
    GST : {{ number_format($project->tax,2) }} <br>
    <div class="grand-total">
        Grand Total : {{ number_format($project->grand_total,2) }}
    </div>
</div>

<div class="section-title">Terms & Conditions</div>
<div class="info-box">
    {!! $project->terms !!}
</div>

@endsection