@extends('pdf.layouts.interior')

@section('title','Premium Quotation')

@section('content')

<div class="section-title">Room Wise Quotation</div>

@foreach($project->areas as $area)

<h4>{{ $area->area_name }}</h4>

<table>
    <thead>
        <tr>
            <th>Img</th>
            <th>Item</th>
            <th>Size</th>
            <th>Qty</th>
            <th>Rate</th>
            <th>Total</th>
        </tr>
    </thead>

    <tbody>

        {{-- ✅ ONLY NON CUSTOM ITEMS --}}
        @foreach($area->items->where('is_custom', 0) as $item)

        <tr>

            <td>
                @if($item->variant && $item->variant->primaryImage)
                    <img src="{{ public_path($item->variant->primaryImage->image_path) }}" 
                         class="product-img" width="50" height="50">
                @endif
            </td>

            <td>{{ ucfirst($item->category) }}</td>

            <td>
                @if($item->measurement)
                    {{ $item->measurement->width }} x {{ $item->measurement->height }}
                @else
                    -
                @endif
            </td>

            {{-- Quantity --}}
            @if($item->category == 'curtain')
                <td>{{ $item->quantity }} pcs</td>
            @elseif($item->category == 'wallpaper')
                <td>{{ $item->quantity }} rolls</td>
            @else
                <td>{{ $item->quantity }}</td>
            @endif

            @php
                $price = (float) ($item->variant?->offer_price ?? 0);
                $qty = (int) ($item->quantity ?? 1);
                $total = $price * $qty;
            @endphp

            <td>{{ $price > 0 ? number_format($price, 2) : '-' }}</td>
            <td>{{ $total > 0 ? number_format($total, 2) : '-' }}</td>

        </tr>

        @endforeach

    </tbody>
</table>

@endforeach


<div class="total-box text-right">
    Subtotal : {{ number_format($project->subtotal,2) }} <br>
    GST : {{ number_format($project->tax,2) }} <br>
    <div class="grand-total">
        Grand Total : {{ number_format($project->grand_total,2) }}
    </div>
</div>

<div class="section-title">Terms & Conditions</div>
<div class="info-box">
    {!! $project->terms !!}
</div>

@endsection
