@extends('pdf.layouts.order-interior')
@section('title','Invoice')

@section('content')

{{-- HEADER --}}
<table class="header-table">
    <tr>
        <td width="60%">
            <img src="{{ public_path('assets/images/logo-dark.png') }}" height="60">
        </td>

        <td width="40%">
            <div class="company-box">
                <strong>Cusella</strong><br>
                Veenalukkal Parappur, po, Kottakkal, Kerala 676503<br>
                Contact:094955 92491
            </div>
        </td>
    </tr>
</table>

<div class="estimate-title">INVOICE</div>

{{-- CLIENT INFO --}}
<table class="info-table">
    <tr>
        <td><strong>Name:</strong> {{ $order->customer_name }}</td>
        <td><strong>Date:</strong> {{ now()->format('d-M-Y') }}</td>
    </tr>
    <tr>
        <td><strong>Contact:</strong> {{ $order->customer_phone }}</td>
        <td><strong>Invoice No:</strong> {{ $order->order_number }}</td>
    </tr>
</table>

{{-- ITEM TABLE --}}
<table>
    <thead>
        <tr>
            <th>No</th>
            <th>Item</th>
            <th>Unit</th>
            <th>Qty</th>
            <th>Price</th>
            <th>Amount</th>
        </tr>
    </thead>

    <tbody>

        @php $i=1; @endphp

        @foreach($order->items as $item)

        @php
        $price = $item->variant ? $item->variant->offer_price : 0;
        $amount = $price * $item->quantity;
        @endphp

        <tr>
            <td>{{ $i++ }}</td>
            <td>{{ $item->product_name }}</td>
            <td>Nos</td>
            <td>{{ $item->quantity }}</td>
            <td>{{ number_format($price,2) }}</td>
            <td>{{ number_format($amount,2) }}</td>
        </tr>

        @endforeach

    </tbody>
</table>

{{-- TOTAL --}}
<table class="total-section">
    <tr>
        <td width="70%">
            <strong>{{ number_format($order->total_amount,2) }} RUPEES ONLY</strong>
        </td>

        <td width="30%">
            <div class="amount-box">
                ₹ {{ number_format($order->total_amount,2) }}
            </div>
        </td>
    </tr>
</table>

<div class="signature">
    Authorized Signature
</div>

@endsection