@extends('pdf.layouts.interior')

@section('title','Project Measurement')

@section('content')

<div class="section-title">Measurement Details</div>

<table>

    <thead>
        <tr>
            <th width="5%">Sl</th>
            <th width="12%">Size</th>
            <th width="15%">Room</th>
            <th width="12%">Item</th>
            <th width="15%">Catalog</th>
            <th width="10%">Serial</th>
            <th>Description</th>
        </tr>
    </thead>

    <tbody>

        @php $sl=1; @endphp

        @foreach($project->areas as $area)
        @foreach($area->items as $item)

        @if(in_array($item->category, [
        'curtain',
        'wallpaper',
        'sofa',
        'mattress',
        'accessories'
        ]))

        <tr>

            <td>{{ $sl++ }}</td>

            {{-- SIZE --}}
            <td>
                @if($item->measurement)
                {{ $item->measurement->width }} x
                {{ $item->measurement->height }}
                {{ $item->measurement->unit }}

                @elseif($item->category == 'mattress')
                {{ optional($item->mattress)->size }}
                {{ optional($item->mattress)->unit }}

                @elseif($item->category == 'accessories')
                Qty: {{ $item->quantity }}

                @endif
            </td>

            {{-- ROOM --}}
            <td>{{ $area->area_name }}</td>

            {{-- ITEM TYPE --}}
            <td>{{ ucfirst($item->category) }}</td>

            {{-- CATALOG --}}
            <td>
                @if($item->curtain)
                {{ $item->curtain->catalogue }}

                @elseif($item->wallpaper)
                {{ $item->wallpaper->catalogue }}

                @elseif($item->sofa)
                {{ $item->sofa->fabric_catalogue }}

                @elseif(in_array($item->category, ['mattress','accessories']))
                {{ optional($item->product)->name }}
                @endif
            </td>

            {{-- SERIAL --}}
            <td>
                @if($item->curtain)
                {{ $item->curtain->serial_no }}

                @elseif($item->wallpaper)
                {{ $item->wallpaper->serial_no }}

                @elseif($item->sofa)
                {{ $item->sofa->serial_no }}

                @elseif(in_array($item->category, ['mattress','accessories']))
                {{ optional($item->variant)->serial_no ?? optional($item->variant)->sku }}
                @endif
            </td>

            {{-- DESCRIPTION --}}
            <td>{{ $item->notes }}</td>

        </tr>

        @endif

        @endforeach
        @endforeach


    </tbody>


</table>

@endsection