<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">

    <style>
        :root {
            --theme: #1f3c88;
            --light: #f4f6f9;
            --border: #dcdcdc;
        }

        /* ✅ VERY IMPORTANT — HEADER HEIGHT SPACE */
        @page {
            margin: 200px 30px 80px 30px;
        }

        body {
            font-family: DejaVu Sans;
            font-size: 12px;
            color: #333;
        }

        /* ✅ FIX HEADER POSITION */
        header {
            position: fixed;
            top: -180px;
            left: 0;
            right: 0;
        }

        /* ✅ FOOTER */
        footer {
            position: fixed;
            bottom: -60px;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 10px;
        }

        /* watermark */
        .watermark {
            position: fixed;
            top: 35%;
            left: 20%;
            opacity: 0.05;
            z-index: -1;
        }

        .logo {
            width: 160px;
        }

        .section-title {
            background: var(--theme);
            color: #fff;
            padding: 6px;
            margin-top: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        thead {
            display: table-header-group;
        }

        th,
        td {
            border: 1px solid var(--border);
            padding: 6px;
        }

        th {
            background: var(--light);
        }

        .pagenum:before {
            content: counter(page);
        }
    </style>

</head>

<body>

    <div class="watermark">
        <img src="{{public_path('assets/images/logo-dark.png')}}" width="350">
    </div>
    <header>

        <table width="100%">
            <tr>

                <td width="60%" style="vertical-align:top;">

                    <img src="{{public_path('assets/images/logo-dark.png')}}" class="logo">

                    <h3 style="margin:5px 0;color:var(--theme);">
                        @yield('title', 'Default Title')

                    </h3>

                    Client : {{ $quotation->customer_name }} <br>
                    Phone : {{ $quotation->customer_phone }} <br>
                    Address : {{ $quotation->address }}

                </td>

                <td width="40%" style="vertical-align:top; text-align:right;">

                    Order Date : {{ $quotation->order_date }} <br>
                    Completion Date : {{ $quotation->expected_completion_date }} <br>
                    Measured By : {{ $quotation->employee_name }} <br>
                    Status : {{ $quotation->status }}

                </td>

            </tr>
        </table>

    </header>



    <footer>
        Cusella |
        Page <span class="pagenum"></span>
    </footer>

    <main>
        @yield('content')
    </main>

</body>

</html>