<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">

    <style>
        :root {
            --theme: #1f3c88;
            --light: #f4f6f9;
            --border: #dcdcdc;
        }

        /* PAGE MARGIN — controls header/footer space */
        @page {
            margin: 190px 30px 80px 30px;
        }

        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            color: #333;
        }

        /* HEADER */
        header {
            position: fixed;
            top: -170px;
            left: 0;
            right: 0;
        }

        /* FOOTER */
        footer {
            position: fixed;
            bottom: -60px;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 10px;
            color: #777;
        }

        /* WATERMARK */
        .watermark {
            position: fixed;
            top: 32%;
            left: 18%;
            opacity: 0.05;
            z-index: -1;
        }

        .logo {
            width: 150px;
        }

        /* TABLE */
        table {
            width: 100%;
            border-collapse: collapse;
        }

        thead {
            display: table-header-group;
        }

        th,
        td {
            border: 1px solid var(--border);
            padding: 6px;
        }

        th {
            background: var(--light);
        }

        /* SECTION TITLE */
        .section-title {
            background: var(--theme);
            color: #fff;
            padding: 6px;
            margin-top: 12px;
            font-weight: bold;
        }

        /* PAGE NUMBER */
        .pagenum:before {
            content: counter(page);
        }
    </style>
</head>

<body>

    {{-- WATERMARK --}}
    <div class="watermark">
        <img src="{{ public_path('assets/images/logo-dark.png') }}" width="350">
    </div>

    {{-- HEADER --}}
    <header>

        <table>
            <tr>

                <td width="60%" style="vertical-align:top;">

                    <img src="{{ public_path('assets/images/logo-dark.png') }}" class="logo">

                    <h3 style="margin:5px 0;color:var(--theme);">
                        @yield('title','Invoice')
                    </h3>

                    <strong>Client :</strong>
                    {{ $order->billingAddress->name ?? '-' }} <br>

                    <strong>Phone :</strong>
                    {{ $order->billingAddress->phone ?? '-' }} <br>

                    <strong>Address :</strong>
                    {{ $order->billing_full_address }}



                </td>

                <td width="40%" style="vertical-align:top;text-align:right;">

                    <strong>Order Date :</strong>
                    {{ $order->created_at ? $order->created_at->format('d-M-Y') : '-' }} <br>

                    <strong>Completion Date :</strong>
                    {{ $order->expected_delivery_date
? $order->expected_delivery_date->format('d-M-Y')
: '-' }} <br>

                    <strong>Status :</strong>
                    {{ ucfirst($order->status ?? '-') }}


                </td>

            </tr>
        </table>

    </header>

    {{-- FOOTER --}}
    <footer>
        Cusella |
        Page <span class="pagenum"></span>
    </footer>

    {{-- MAIN CONTENT --}}
    <main>
        @yield('content')
    </main>

</body>

</html>