@extends('pdf.layouts.interior')
@section('title','Invoice')

@section('content')

<style>
    body{
        font-family: DejaVu Sans, sans-serif;
        font-size: 12px;
        color:#000;
    }
    .header-table{
        width:100%;
        margin-bottom:10px;
    }
    .header-table td{
        vertical-align: top;
    }
    .company-box{
        text-align:right;
        border:1px solid #000;
        padding:8px;
        font-size:11px;
    }
    .estimate-title{
        text-align:center;
        font-weight:bold;
        background:#eee;
        padding:6px;
        border:1px solid #000;
        margin-top:10px;
    }
    .info-table{
        width:100%;
        border:1px solid #000;
        border-collapse: collapse;
    }
    .info-table td{
        padding:5px;
        border:1px solid #000;
    }
    table{
        width:100%;
        border-collapse: collapse;
        margin-top:10px;
    }
    table th, table td{
        border:1px solid #000;
        padding:6px;
        text-align:center;
        font-size:11px;
    }
    table th{
        background:#f3f3f3;
    }
    .total-section{
        width:100%;
        margin-top:15px;
    }
    .amount-box{
        border:1px solid #000;
        padding:10px;
        font-size:18px;
        font-weight:bold;
        text-align:right;
    }
    .terms{
        margin-top:15px;
        font-size:11px;
    }
    .signature{
        margin-top:40px;
        text-align:right;
    }
</style>


{{-- HEADER --}}
<table class="header-table">
    <tr>
        <td width="60%">
            <img src="{{public_path('assets/images/logo-dark.png')}}" height="60">
        </td>

        <td width="40%">
            <div class="company-box">
                <strong>Cusella</strong><br>
               Veenalukkal Parappur, po, Kottakkal, Kerala 676503<br>
                Contact:094955 92491, 9876543210
            </div>
        </td>
    </tr>
</table>


<div class="estimate-title">INVOICE</div>


{{-- CLIENT INFO --}}
<table class="info-table">
    <tr>
        <td><strong>Name:</strong> {{ $project->client_name }}</td>
        <td><strong>Date:</strong> {{ now()->format('d-M-Y') }}</td>
    </tr>
    <tr>
        <td><strong>Contact:</strong> {{ $project->client_phone }}</td>
        <td><strong>Invoice No:</strong> {{ $project->invoice_no }}</td>
    </tr>
</table>



{{-- ITEM TABLE --}}
<table>
    <thead>
        <tr>
            <th>No</th>
            <th>Item</th>
            <th>Unit</th>
            <th>Qty</th>
            <th>Price</th>
            <th>Amount</th>
        </tr>
    </thead>
    <tbody>
@php $i = 1; @endphp

@foreach($project->areas as $area)
@foreach($area->items as $item)

@php
    $unit = 'Nos';
    $qty = 0;
    $price = 0;
    $amount = 0;

    // ==============================
    // NON CUSTOM PRODUCTS
    // ==============================
    if($item->is_custom == 0){

        $price = (float) ($item->variant->offer_price ?? 0);
        $qty   = (float) ($item->quantity ?? 1);
        $amount = $price * $qty;

        if($item->category == 'curtain'){
            $unit = 'Pcs';
        }
        elseif($item->category == 'wallpaper'){
            $unit = 'Rolls';
        }

    }
    // ==============================
    // CUSTOM CURTAIN
    // ==============================
    elseif($item->category == 'curtain' && $item->curtain && $item->measurement){

        $fw = (float) $item->curtain->fabric_width;
        $ww = (float) $item->measurement->width;
        $wh = (float) $item->measurement->height;
        $price = (float) $item->curtain->price_per_meter;

        if($fw > 0){
            $panels = ceil($ww / $fw);
            $qty = $panels * $wh; // fabric in meters
        }

        $unit = 'Meter';
        $amount = $qty * $price;
    }
    // ==============================
    // CUSTOM WALLPAPER
    // ==============================
    elseif($item->category == 'wallpaper' && $item->wallpaper){

        $rw = (float) $item->wallpaper->roll_width;
        $rl = (float) $item->wallpaper->roll_length;
        $ww = (float) $item->wallpaper->wall_width;
        $wh = (float) $item->wallpaper->wall_height;
        $rep = (float) ($item->wallpaper->design_repeat ?? 0);
        $price = (float) $item->wallpaper->price_per_roll;

        if($rw > 0 && $rl > 0){
            $cuttings = ceil($ww / $rw);
            $totalLength = $cuttings * ($wh + $rep);
            $qty = ceil($totalLength / $rl);
        }

        $unit = 'Rolls';
        $amount = $qty * $price;
    }
@endphp

<tr>
    <td>{{ $i++ }}</td>
    <td>{{ ucfirst($item->category) }}</td>
    <td>{{ $unit }}</td>
    <!-- <td>{{ $qty > 0 ? number_format($qty,2) : '-' }}</td> -->
       @if($item->is_custom == 0)

            @if($item->category == 'curtain')
            <td>{{ $item->quantity }} pcs</td>
            @elseif($item->category == 'wallpaper')
            <td>{{ $item->quantity }} rolls</td>
            @else
            <td>{{ $item->quantity }}</td>
            @endif

            @elseif($item->category == 'curtain' && $item->curtain && $item->measurement)

            @php
            $fw = (float) $item->curtain->fabric_width;
            $ww = (float) $item->measurement->width;
            $wh = (float) $item->measurement->height;

            $qty = ($fw > 0) ? ceil($ww / $fw) * $wh : 0;
            @endphp

            <td>{{ $qty > 0 ? number_format($qty,2).' m' : '-' }}</td>

            @elseif($item->category == 'wallpaper' && $item->wallpaper)

            @php
            $rw = (float) $item->wallpaper->roll_width;
            $rl = (float) $item->wallpaper->roll_length;
            $ww = (float) $item->wallpaper->wall_width;
            $wh = (float) $item->wallpaper->wall_height;
            $rep = (float) ($item->wallpaper->design_repeat ?? 0);

            $cuttings = ($rw > 0) ? ceil($ww / $rw) : 0;
            $qty = ($rl > 0) ? ceil(($cuttings * ($wh + $rep)) / $rl) : 0;
            @endphp

            <td>{{ $qty > 0 ? $qty.' rolls' : '-' }}</td>

            @else

            <td>-</td>

            @endif
            
    <td>{{ $price > 0 ? number_format($price,2) : '-' }}</td>
    <td>{{ $amount > 0 ? number_format($amount,2) : '-' }}</td>
</tr>

@endforeach
@endforeach


    </tbody>
</table>


{{-- TOTAL SECTION --}}
<div class="total-box text-right">
    Subtotal : ₹ {{ number_format($project->subtotal, 2) }} <br>
    GST : ₹ {{ number_format($project->tax, 2) }} <br>
    <div class="grand-total">
        Grand Total : ₹ {{ number_format($project->grand_total, 2) }}
    </div>
</div>

<table class="total-section">
    <tr>
        <td width="70%">
            <strong>
                {{ number_format($project->grand_total, 2) }} RUPEES ONLY
            </strong>
        </td>
        <td width="30%">
            <div class="amount-box">
                ₹ {{ number_format($project->grand_total,2) }}
            </div>
        </td>
    </tr>
</table>




{{-- TERMS --}}
<div class="terms">
    <strong>Terms & Conditions</strong>
    <br><br>
    {!! $project->terms !!}
</div>



{{-- FOOTER --}}
<div class="signature">
    Authorized Signature
</div>

@endsection
