@extends('pdf.layouts.quotation-interior')

@section('title','Quotation')

@section('content')

<div class="section-title">Room Wise Quotation</div>

@foreach($quotation->areas as $area)

<h4>{{ $area->area_name }}</h4>

<table>
    <thead>
        <tr>
            <th>Img</th>
            <th>Item</th>
            <th>Size</th>
            <th>Qty</th>
            <th>Rate</th>
            <th>Total</th>
        </tr>
    </thead>

    <tbody>

   @foreach($groupedItems[$area->id] ?? [] as $item)

        <tr>
            <td>
                @if($item->variant && $item->variant->primaryImage)
                    <img src="{{ public_path($item->variant->primaryImage->image_path) }}" 
                         width="50" height="50">
                @endif
            </td>

            <td>{{ ucfirst($item->category) }},
<br>
             {{ $item->product->name ?? '' }},<br>
                              {{ $item->variant->sku ?? '' }},
            </td>

            <td>
@php
    $measurement = null;
    $detailsData = null;

    $itemDetails = $item->details()->first();

    // Decode measurement
    if ($itemDetails && $itemDetails->measurement) {
        $decoded = json_decode($itemDetails->measurement, true);
        if (is_string($decoded)) {
            $decoded = json_decode($decoded, true);
        }
        $measurement = $decoded;
    }

    // Decode details (for mattress)
    if ($itemDetails && $itemDetails->details) {
        $decodedDetails = json_decode($itemDetails->details, true);
        if (is_string($decodedDetails)) {
            $decodedDetails = json_decode($decodedDetails, true);
        }
        $detailsData = $decodedDetails;
    }
@endphp

@if($item->category == 'curtain' || $item->category == 'wallpaper')

    @if(isset($measurement['width']) && isset($measurement['height']))
        {{ $measurement['width'] }} x {{ $measurement['height'] }}
        {{ $measurement['unit'] ?? '' }}

    @elseif(isset($measurement['curtain']))
        {{ $measurement['curtain']['width'] ?? '' }}
        x
        {{ $measurement['curtain']['height'] ?? '' }}
        {{ $measurement['curtain']['unit'] ?? '' }}

    @elseif(isset($measurement['wallpaper']))
        {{ $measurement['wallpaper']['width'] ?? '' }}
        x
        {{ $measurement['wallpaper']['height'] ?? '' }}
        {{ $measurement['wallpaper']['unit'] ?? '' }}

    @else
        -
    @endif

@elseif($item->category == 'mattress')

    @if($detailsData && isset($detailsData['size']))
        {{ $detailsData['size'] }}
        {{ $detailsData['unit'] ?? '' }}
    @else
        -
    @endif

@else
    -
@endif
</td>


            {{-- Quantity --}}
            @if($item->category == 'curtain')
                <td>{{ $item->quantity }} pcs</td>
            @elseif($item->category == 'wallpaper')
                <td>{{ $item->quantity }} rolls</td>
            @else
                <td>{{ round($item->quantity,0) }}</td>
            @endif

            @php
                $price = (float) ($item->variant?->offer_price ?? 0);
                $qty = (int) ($item->quantity ?? 1);
                $total = $price * $qty;
            @endphp

            <td>{{ $price > 0 ? number_format($price, 2) : '-' }}</td>
            <td>{{ $total > 0 ? number_format($total, 2) : '-' }}</td>

        </tr>

    @endforeach

    </tbody>
</table>

@endforeach


<div class="total-box text-right">
    Subtotal : {{ number_format($quotation->subtotal,2) }} <br>
    GST : {{ number_format($quotation->tax,2) }} <br>
    <div class="grand-total">
        Grand Total : {{ number_format($quotation->grand_total,2) }}
    </div>
</div>

<div class="section-title">Terms & Conditions</div>
<div class="info-box">
    {!! $quotation->terms !!}
</div>

@endsection