@extends('admin.layout.template')
@section('title','Dashboard')

@section('content')

<div class="page-content">
    <div class="container-fluid">

        <div class="row">

            {{-- TOTAL ORDERS --}}
            <div class="col-md-3">
                <div class="card">
                    <div class="card-body d-flex justify-content-between">
                        <div>
                            <p class="text-muted">Total Orders</p>
                            <h3>{{ $totalOrders }}</h3>
                        </div>
                        <div class="avatar-md bg-soft-primary rounded">
                            <iconify-icon icon="solar:cart-5-bold-duotone"
                                class="avatar-title fs-32 text-primary"></iconify-icon>
                        </div>
                    </div>
                </div>
            </div>

            {{-- PRODUCTS --}}
            <div class="col-md-3">
                <div class="card">
                    <div class="card-body d-flex justify-content-between">
                        <div>
                            <p class="text-muted">Products</p>
                            <h3>{{ $totalProducts }}</h3>
                        </div>
                        <div class="avatar-md bg-soft-success rounded">
                            <iconify-icon icon="solar:box-bold-duotone"
                                class="avatar-title fs-32 text-success"></iconify-icon>
                        </div>
                    </div>
                </div>
            </div>

            {{-- USERS --}}
            <div class="col-md-3">
                <div class="card">
                    <div class="card-body d-flex justify-content-between">
                        <div>
                            <p class="text-muted">Users</p>
                            <h3>{{ $totalUsers }}</h3>
                        </div>
                        <div class="avatar-md bg-soft-warning rounded">
                            <iconify-icon icon="solar:users-group-rounded-bold-duotone"
                                class="avatar-title fs-32 text-warning"></iconify-icon>
                        </div>
                    </div>
                </div>
            </div>

            {{-- PROJECTS --}}
            <div class="col-md-3">
                <div class="card">
                    <div class="card-body d-flex justify-content-between">
                        <div>
                            <p class="text-muted">Projects</p>
                            <h3>{{ $totalProjects }}</h3>
                        </div>
                        <div class="avatar-md bg-soft-info rounded">
                            <iconify-icon icon="solar:buildings-bold-duotone"
                                class="avatar-title fs-32 text-info"></iconify-icon>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        {{-- REVENUE + CHART --}}
        <div class="row">

            <div class="col-lg-4">
                <div class="card">
                    <div class="card-body text-center">
                        <h5>Total Revenue</h5>
                        <h2 class="text-success">₹ {{ number_format($totalRevenue,2) }}</h2>
                    </div>
                </div>
                <div class="card">
                    <div class="card-body text-center">
                        <h5>Pending Role request</h5>
                        <h2 class="text-warning"> {{ number_format($totalPendingRoleRequest) }}</h2>
                    </div>
                </div>
            </div>

            <div class="col-lg-8">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Sales Performance</h4>
                        <div id="dashboardChart" style="height:300px;"></div>
                    </div>
                </div>
            </div>

        </div>

        {{-- RECENT ORDERS --}}
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Recent Orders</h4>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-centered">
                            <thead class="bg-light">
                                <tr>
                                    <th>#</th>
                                    <th>Customer</th>
                                    <th>Total</th>
                                    <th>Status</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>

                                @foreach($recentOrders as $order)
                                <tr>
                                    <td>#{{ $order->order_number }}</td>
                                    <td>{{ $order->user->name ?? '-' }}</td>
                                    <td>₹ {{ number_format($order->total,2) }}</td>
                                    <td>
                                        <span class="badge bg-{{ $order->status=='delivered'?'success':'warning' }}">
                                            {{ ucfirst($order->status) }}
                                        </span>
                                    </td>
                                    <td>{{ $order->created_at->format('d M Y') }}</td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>

    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
{{-- CHART --}}
<script>
    var options = {
        chart: {
            type: 'area',
            height: 300
        },
        series: [{
            name: 'Orders',
            data: [10, 20, 15, 30, 25, 40, 35]
        }],
        xaxis: {
            categories: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun']
        }
    };
    new ApexCharts(document.querySelector("#dashboardChart"), options).render();
</script>

@endsection