@extends('admin.layout.template')
@section('title','Wholesale Enquiry')

@section('content')

<div class="page-content">
    <div class="container-xxl">

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Wholesale Enquiries</h4>
            </div>

            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover table-centered mb-0" id="enquiryTable">
                        <thead class="bg-light-subtle">
                            <tr>
                                <th>SL.NO</th>
                                <th>Name</th>
                                <th>Phone</th>
                                <th>Place</th>
                                <th>Message</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>
</div>

<script>
    $(function() {

        var table = $('#enquiryTable').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('get-wholesale-enquiry') }}",
           columns: [
{
data: 'DT_RowIndex',
name: 'DT_RowIndex',
orderable: false,
searchable: false
},
{
data: 'full_name',
name: 'full_name'
},
{
data: 'phone_number',
name: 'phone_number'
},
{
data: 'place',
name: 'place'
},
{
data: 'message',
name: 'message'
},
{
data: 'action',
name: 'action',
orderable: false,
searchable: false
}
]

        });

        $(document).on('click', '.deleteEnquiry', function(e) {
            e.preventDefault();

            var id = $(this).data('id');

            Swal.fire({
                title: 'Are you sure?',
                text: "Delete this enquiry?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes Delete'
            }).then((result) => {

                if (result.isConfirmed) {

                    $.ajax({
                        url: "{{ url('delete-wholesale-enquiry') }}/" + id,
                        type: 'DELETE',
                        data: {
                            _token: '{{ csrf_token() }}'
                        },

                        success: function(res) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Deleted!',
                                text: res.success,
                                timer: 1500,
                                showConfirmButton: false
                            });
                            table.ajax.reload();
                        },

                        error: function() {
                            Swal.fire('Error', 'Delete failed', 'error');
                        }

                    });

                }

            });

        });

    });
</script>

@endsection