<div class="modal fade" id="userModal" tabindex="-1">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content">

            <form id="userForm">
                @csrf
                <input type="hidden" id="user_id">

                <div class="modal-header">
                    <h5 class="modal-title">User Management</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <div class="row g-3">

                        <!-- Name -->
                        <div class="col-md-4">
                            <label class="form-label">Name</label>
                            <input type="text" class="form-control" name="name" required>
                        </div>

                        <!-- Email -->
                        <div class="col-md-4">
                            <label class="form-label">Email</label>
                            <input type="email" class="form-control" name="email" required>
                        </div>

                        <!-- Phone -->
                        <div class="col-md-4">
                            <label class="form-label">Phone</label>
                            <input type="text" class="form-control" name="phone">
                        </div>

                        <!-- Password -->
                        <div class="col-md-4">
                            <label class="form-label">Password</label>
                            <input type="password" class="form-control" name="password">
                            <small class="text-muted">Leave blank to keep existing</small>
                        </div>

                        <!-- Role -->
                        <div class="col-md-4">
                            <label class="form-label">Role</label>
                            <select class="form-select" name="role" required>
                                <option value="">Select Role</option>
                                @foreach(\Spatie\Permission\Models\Role::all() as $role)
                                    <option value="{{ $role->id }}">{{ ucfirst($role->name) }}</option>
                                @endforeach
                            </select>
                        </div>

                        <!-- User Type -->
                        <div class="col-md-4">
                            <label class="form-label">User Type</label>
                            <select class="form-select" name="user_type" required>
                                <option value="">Select Type</option>
                                <option value="super_admin">Super Admin</option>
                                <option value="cusella_internal">Cusella Internal</option>
                                <option value="zonal_franchise">Zonal Franchise</option>
                                <option value="franchise">Franchise</option>
                                <option value="dealer">Dealer</option>
                                <option value="architect">Architect</option>
                                <option value="customer">Customer</option>
                            </select>
                        </div>

                       
                        <!-- Reporting Manager -->
                        <div class="col-md-4">
                            <label class="form-label">Reporting Manager</label>
                            <select class="form-select" name="reporting_manager_id" id="choices-single-no-sorting" data-choices data-choices-sorting-false>>
                                <option value="">Select Manager</option>
                                @foreach(\App\Models\User::all() as $manager)
                                    <option value="{{ $manager->id }}">{{ $manager->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Joining Date -->
                        <div class="col-md-4">
                            <label class="form-label">Joining Date</label>
                            <input type="date" class="form-control" name="joining_date">
                        </div>

                        <!-- Access Expiry -->
                        <div class="col-md-4">
                            <label class="form-label">Access Expiry</label>
                            <input type="date" class="form-control" name="access_expires_at">
                        </div>

                        <!-- Status -->
                        <div class="col-md-4">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="status" required>
                                <option value="Active">Active</option>
                                <option value="Block">Blocked</option>
                            </select>
                        </div>

                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
                    <button class="btn btn-primary">Save User</button>
                </div>

            </form>

        </div>
    </div>
</div>
