@extends('admin.layout.template')
@section('title', 'Login History')

@section('content')
<div class="page-content">
    <div class="container-xxl">

        <div class="d-flex justify-content-between mb-3">
            <h4>
                Login History – {{ $user->name }}
                @if($user->isOnline())
                    <span class="badge bg-success">Online</span>
                @else
                    <span class="badge bg-secondary">Offline</span>
                @endif
            </h4>

            <button class="btn btn-danger" id="deleteAll">
                Delete All History
            </button>
        </div>

        <div class="card">
            <div class="card-body">
                <table class="table table-striped" id="historyTable">
                    <thead>
                        <tr>
                            <th>Login At</th>
                            <th>Logout At</th>
                            <th>Device</th>
                            <th>IP Address</th>
                            <th width="100">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($activities as $activity)
                        <tr id="row-{{ $activity->id }}">
                            <td>{{ $activity->login_at }}</td>
                            <td>{{ $activity->logout_at ?? '—' }}</td>
                            <td>{{ $activity->device }}</td>
                            <td>{{ $activity->ip_address }}</td>
                            <td>
                                <button class="btn btn-sm btn-danger deleteActivity"
                                        data-id="{{ $activity->id }}">
                                    Delete
                                </button>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

    </div>
</div>

<script>
$(document).ready(function () {
    $('#historyTable').DataTable();

    // Delete single activity
    $('.deleteActivity').click(function () {
        let id = $(this).data('id');

        Swal.fire({
            title: 'Delete this record?',
            icon: 'warning',
            showCancelButton: true
        }).then(res => {
            if (res.isConfirmed) {
                $.ajax({
                    url: "{{ url('login-history') }}/" + id,
                    type: 'DELETE',
                    data: {_token: '{{ csrf_token() }}'},
                    success: function () {
                        $('#row-' + id).remove();
                    }
                });
            }
        });
    });

    // Delete all history
    $('#deleteAll').click(function () {
        Swal.fire({
            title: 'Delete ALL login history?',
            text: 'This action cannot be undone!',
            icon: 'warning',
            showCancelButton: true
        }).then(res => {
            if (res.isConfirmed) {
                $.ajax({
                    url: `{{ route('users.login.history.deleteAll', $user->id) }}`,
                    type: 'DELETE',
                    data: {_token: '{{ csrf_token() }}'},
                    success: function () {
                        location.reload();
                    }
                });
            }
        });
    });
});
</script>
@endsection
