@extends('admin.layout.template')
@section('title', 'Users')

@section('content')
<div class="page-content">
    <div class="container-xxl">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 py-0">
                <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{route('users.index')}}">Users</a></li>
            </ol>
        </nav>
        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <h4>Users</h4>
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#userModal">
                    + Add User
                </button>

            </div>

            <div class="card-body">
                <table id="usersTable" class="table  table-striped table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Yser Type</th>
                            <th>Role</th>
                            <th>Reporting Manager</th>
                            <th>Department</th>
                            <th>Status</th>
                            <th width="160">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($users as $i => $user)
                        <tr id="row-{{ $user->id }}">
                            <td>{{ $i+1 }}</td>
                            <td>{{ $user->name }}
                                @if($user->isOnline())
                                <span class="badge bg-success">Online</span>
                                @else
                                <span class="badge bg-secondary">Offline</span>
                                @endif
                                <span class="d-flex align-items-center">
                            </td>
                            <td>{{ $user->email }}</td>
                            <td>{{ $user->user_type }}</td>
                            <td>{{ $user->roles->pluck('name')->first() }}</td>

                            {{-- Reporting Manager --}}
                            <td>{{ $user->manager ? $user->manager->name : '-' }}</td>

                            {{-- Department --}}
                            <td>
                                @php $role = $user->roles->first(); @endphp

                                @forelse($role?->departments ?? [] as $dept)
                                <span class="badge bg-primary me-1">{{ $dept->name }}</span>
                                @empty
                                <span class="text-muted">—</span>
                                @endforelse
                            </td>

                            <td>

                                @if($user->status=='Active')
                                <span class="badge bg-success-subtle text-success py-1 px-2">{{$user->status}}</span>
                                @else
                                <span class="badge bg-success-subtle text-danger py-1 px-2">{{$user->status}}</span>
                                @endif
                            </td>
                            <td>
                                <button class="btn btn-sm btn-success mb-1"
                                    onclick="openAssignModal({{ $user->id }})">
                                    Assign User/Location
                                </button>
                                <br>
                                <a href="{{ route('users.view', $user->id) }}"
                                    class="btn btn-sm btn-info">
                                    View
                                </a>



                                <button class="btn btn-sm btn-warning editUser" data-id="{{ $user->id }}">Edit
                                </button>
                                <button class="btn btn-sm btn-danger deleteUser" data-id="{{ $user->id }}">Delete
                                </button>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        @include('admin.users.modal')

        <!-- Assign Modal -->
        <div class="modal fade" id="assignModal" tabindex="-1">
            <div class="modal-dialog modal-xl">
                <form id="assignForm">
                    @csrf
                    <input type="hidden" name="user_id" id="assign_user_id">

                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Assign Users & Locations</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>

                        <div class="modal-body row g-3">

                            <!-- Assigned Users -->
                            <div class="col-md-12 mb-3">
                                <label class="form-label">Assigned Users</label>
                                <select class="form-select" id="assignedUsersSelect"
                                    name="assigned_users[]" multiple>
                                </select>
                            </div>

                            <!-- Assigned Locations -->
                            <div class="col-md-12">
                                <label class="form-label">Assigned Locations</label>
                                <select class="form-select" id="assignedLocationsSelect"
                                    name="assigned_locations[]" multiple>
                                    @foreach(\App\Models\Location::all() as $location)
                                    <option value="{{ $location->id }}">{{ $location->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                        </div>

                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- end assign modal -->
    </div>
</div>

<script>
    const usersBaseUrl = "{{ url('/users') }}";


    $(document).ready(function() {
        $('#usersTable').DataTable({
            pageLength: 10,
            ordering: true,
            responsive: true
        });
    });
    /* ADD */
    $('#userForm').submit(function(e) {
        e.preventDefault();

        let id = $('#user_id').val();
        let url = id ? `${usersBaseUrl}/${id}` : usersBaseUrl;

        Swal.fire({
            title: 'Are you sure?',
            text: 'Save user details?',
            icon: 'question',
            showCancelButton: true
        }).then((res) => {
            if (res.isConfirmed) {
                $.ajax({
                    url: url,
                    type: 'POST',
                    data: $(this).serialize() + (id ? '&_method=PUT' : ''),
                    success: function(res) {
                        Swal.fire('Success', res.message, 'success')
                            .then(() => location.reload());
                    },
                    error: function(xhr) {
                        if (xhr.status === 422) {
                            let errors = xhr.responseJSON.errors;
                            let errorMessages = [];

                            // Collect all error messages
                            for (const key in errors) {
                                if (errors.hasOwnProperty(key)) {
                                    errorMessages.push(errors[key].join('<br>'));
                                }
                            }

                            Swal.fire({
                                title: 'Validation Error',
                                html: errorMessages.join('<br>'),
                                icon: 'error'
                            });
                        } else {
                            Swal.fire('Error', 'Something went wrong!', 'error');
                        }
                    }
                });
            }
        });
    });


    /* EDIT */
    /* EDIT */
    $('.editUser').click(function() {
        let id = $(this).data('id');

        $.get(`${usersBaseUrl}/${id}/edit`, function(res) {
            $('#user_id').val(res.user.id);
            $('[name=name]').val(res.user.name);
            $('[name=email]').val(res.user.email);
            $('[name=phone]').val(res.user.phone);
            $('[name=joining_date]').val(res.user.joining_date);
            $('[name=access_expires_at]').val(res.user.access_expires_at);

            // Open modal first
            $('#userModal').modal('show');

            setTimeout(() => {
                $('[name=role]').val(res.role).trigger('change');
                $('[name=status]').val(res.user.status).trigger('change');
                $('[name=user_type]').val(res.user.user_type).trigger('change');
                $('[name=department_id]').val(res.user.department_id).trigger('change');
                $('[name=reporting_manager_id]').val(res.user.reporting_manager_id).trigger('change');
            }, 100);
        });
    });



    /* DELETE */
    $('.deleteUser').click(function() {
        let id = $(this).data('id');

        Swal.fire({
            title: 'Are you sure?',
            text: 'Delete user details?',
            icon: 'warning',
            showCancelButton: true
        }).then(res => {
            if (res.isConfirmed) {
                $.ajax({
                    url: `/users/${id}`,
                    type: 'POST',
                    data: {
                        _method: 'DELETE',
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(res) {
                        Swal.fire('Deleted', res.message, 'success');
                        $('#row-' + id).remove();
                    }
                })
            }
        });
    });
</script>
<script>
    let assignedUsersChoices;
    let assignedLocationsChoices;

    function initChoices() {
        assignedUsersChoices = new Choices('#assignedUsersSelect', {
            removeItemButton: true
        });

        assignedLocationsChoices = new Choices('#assignedLocationsSelect', {
            removeItemButton: true
        });
    }
function openAssignModal(userId) {
    $('#assign_user_id').val(userId);

    assignedUsersChoices.clearStore();
    assignedLocationsChoices.clearStore();

    // USERS (same department)
    $.get("{{ route('users.assignable.users', ':id') }}".replace(':id', userId),
        function(users) {
            assignedUsersChoices.setChoices(
                users.map(u => ({
                    value: u.id,
                    label: u.name
                })),
                'value',
                'label',
                false
            );
        }
    );

    // LOCATIONS (selected + others)
    $.get(
        "{{ route('users.assignable.locations', ':id') }}".replace(':id', userId),
        function(locations) {

            assignedLocationsChoices.setChoices(
                locations.map(l => ({
                    value: l.id,
                    label: l.name,
                    selected: l.selected
                })),
                'value',
                'label',
                false
            );
        }
    );

    $('#assignModal').modal('show');
}

    $('#assignForm').submit(function(e) {
        e.preventDefault();

        $.post(
            "{{ route('users.assign.save') }}",
            $(this).serialize(),
            function(res) {
                Swal.fire('Success', res.message, 'success');
                $('#assignModal').modal('hide');
            }
        );
    });

    document.addEventListener('DOMContentLoaded', initChoices);
</script>

@endsection