@extends('admin.layout.template')
@section('title', 'Departments')
@section('content')

<div class="page-content">

    <!-- Start Container Fluid -->
    <div class="container-xxl">

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title d-flex align-items-center gap-1"><iconify-icon icon="solar:settings-bold-duotone" class="text-primary fs-20"></iconify-icon>Add department</h4>
                    </div>
                    <div class="card-body">
                        <form action="{{route('add-department')}}" method="post">
                            @csrf
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="mb-3">
                                        <label for="meta-name" class="form-label">Department</label>
                                        <input type="text" name="name" class="form-control" placeholder="Enter department name" required>
                                    </div>
                                </div>
                                <div class="col-lg-6 mt-3">
                                    <div class="text-start">
                                        <button type="submit" class="btn btn-success">Save Change</button>
                                    </div>
                                </div>

                            </div>

                        </form>
                    </div>
                </div>


                <div class="row">
                    <div class="col-xl-12">
                        <div class="card">

                            <div class="card-body p-0">
                                <div class="table-responsive">
                                    <table class="table align-middle mb-0 table-hover table-centered">
                                        <thead class="bg-light-subtle">
                                            <tr>
                                                <th>SL.NO</th>
                                                <th>Department</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                                <!-- end table-responsive -->
                            </div>

                        </div>
                    </div>

                </div>


            </div>
        </div>
    </div>
</div>

<script>
    $(function() {

        let table = $('.table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('get-departments') }}",
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'status',
                    name: 'status',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }
            ]
        });

        /** DELETE */
        $(document).on('click', '.deleteDepartment', function() {
            let id = $(this).data('id');

            Swal.fire({
                title: 'Are you sure?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "{{ url('/delete-department') }}/" + id,
                        type: 'DELETE',
                        data: {
                            _token: "{{ csrf_token() }}"
                        },
                        success: function(res) {
                            Swal.fire('Deleted!', res.success, 'success');
                            table.ajax.reload();
                        }
                    });
                }
            });
        });

        /** STATUS TOGGLE */
        $(document).on('change', '.toggleStatus', function() {
            let id = $(this).data('id');

            $.post("{{ url('/department-status') }}/" + id, {
                _token: "{{ csrf_token() }}"
            }, function(res) {
                Swal.fire({
                    icon: 'success',
                    title: res.success,
                    timer: 1000,
                    showConfirmButton: false
                });
            });
        });

        /** INLINE EDIT */
        $(document).on('click', '.editDepartment', function() {
            let row = $(this).closest('tr');
            let id = $(this).data('id');
            let name = row.find('td:eq(1)').text().trim();

            row.find('td:eq(1)').html(
                `<input type="text" class="form-control form-control-sm edit-name" value="${name}">`
            );

            $(this).replaceWith(`
            <button class="btn btn-sm btn-success saveDepartment" data-id="${id}">Save</button>
            <button class="btn btn-sm btn-secondary cancelEdit ms-1">Cancel</button>
        `);
        });

        $(document).on('click', '.cancelEdit', function() {
            table.ajax.reload();
        });

        $(document).on('click', '.saveDepartment', function() {
            let id = $(this).data('id');
            let name = $(this).closest('tr').find('.edit-name').val();

            $.ajax({
                url: "{{ url('/update-department') }}/" + id,
                type: 'POST',
                data: {
                    _token: "{{ csrf_token() }}",
                    _method: 'PUT',
                    name: name
                },
                success: function(res) {
                    Swal.fire('Updated!', res.success, 'success');
                    table.ajax.reload();
                }
            });
        });

    });
</script>
@endsection