@extends('admin.layout.template')
@section('title', 'Edit Location')

@section('content')
<div class="page-content">
<div class="container-xxl">

<div class="card">
<div class="card-header">
    <h5>Edit Location</h5>
</div>

<div class="card-body">
<form id="editlocationsForm" >
@csrf

{{-- ================= BASIC INFO ================= --}}
<h6 class="mb-3 text-primary">Basic Information</h6>
<div class="row g-3">

    <div class="col-md-4">
        <label>Location Type <span class="text-danger">*</span></label>
        <select name="type" class="form-control" required>
            @foreach([
                'Warehouse',
                'Franchise',
                'Zonal Franchise',
                'Distributor',
                'Dealer / Showroom',
                'Office / Branch'
            ] as $type)
                <option value="{{ $type }}"
                    {{ $location->type === $type ? 'selected' : '' }}>
                    {{ $type }}
                </option>
            @endforeach
        </select>
    </div>

    <div class="col-md-4">
        <label>Business / Location Name <span class="text-danger">*</span></label>
        <input type="text" name="name" class="form-control"
               value="{{ old('name', $location->name) }}" required>
    </div>

    <div class="col-md-4">
        <label>Display Name <span class="text-danger">*</span></label>
        <input type="hidden" name="id" value="{{ $location->id }}">
        <input type="text" name="display_name" class="form-control"
               value="{{ old('display_name', $location->display_name) }}" required>
    </div>

</div>

<hr>

{{-- ================= ADDRESS ================= --}}
<h6 class="mb-3 text-primary">Address Details</h6>
<div class="row g-3">

    <div class="col-md-4">
        <label>City <span class="text-danger">*</span></label>
        <input type="text" name="city" class="form-control"
               value="{{ old('city', $location->city) }}" required>
    </div>

    <div class="col-md-4">
        <label>District</label>
        <input type="text" name="district" class="form-control"
               value="{{ old('district', $location->district) }}">
    </div>

    <div class="col-md-4">
        <label>State <span class="text-danger">*</span></label>
        <input type="text" name="state" class="form-control"
               value="{{ old('state', $location->state) }}" required>
    </div>

    <div class="col-md-4">
        <label>Country <span class="text-danger">*</span></label>
        <input type="text" name="country" class="form-control"
               value="{{ old('country', $location->country) }}" required>
    </div>

    <div class="col-md-4">
        <label>Pincode</label>
        <input type="text" name="pincode" class="form-control"
               value="{{ old('pincode', $location->pincode) }}">
    </div>

</div>

<hr>

{{-- ================= CONTACT ================= --}}
<h6 class="mb-3 text-primary">Contact Details</h6>
<div class="row g-3">

    <div class="col-md-4">
        <label>Contact Person <span class="text-danger">*</span></label>
        <input type="text" name="contact_person_name" class="form-control"
               value="{{ old('contact_person_name', $location->contact_person_name) }}" required>
    </div>

    <div class="col-md-4">
        <label>Phone <span class="text-danger">*</span></label>
        <input type="text" name="phone" class="form-control"
               value="{{ old('phone', $location->phone) }}" required>
    </div>

    <div class="col-md-4">
        <label>Alternate Phone</label>
        <input type="text" name="alternate_phone" class="form-control"
               value="{{ old('alternate_phone', $location->alternate_phone) }}">
    </div>

    <div class="col-md-4">
        <label>Email</label>
        <input type="email" name="email" class="form-control"
               value="{{ old('email', $location->email) }}">
    </div>

</div>

<hr>

{{-- ================= LEGAL & BILLING ================= --}}
<h6 class="mb-3 text-primary">Legal & Billing</h6>
<div class="row g-3">

    <div class="col-md-4">
        <label>GST Number</label>
        <input type="text" name="gst_number" class="form-control"
               value="{{ old('gst_number', $location->gst_number) }}">
    </div>

    <div class="col-md-4">
        <label>PAN</label>
        <input type="text" name="pan" class="form-control"
               value="{{ old('pan', $location->pan) }}">
    </div>

    <div class="col-md-4">
        <label>Trade License No</label>
        <input type="text" name="trade_license_no" class="form-control"
               value="{{ old('trade_license_no', $location->trade_license_no) }}">
    </div>

    <div class="col-md-6">
        <label>Billing Name</label>
        <input type="text" name="billing_name" class="form-control"
               value="{{ old('billing_name', $location->billing_name) }}">
    </div>

    <div class="col-md-6">
        <label>Billing Address</label>
        <textarea name="billing_address" class="form-control"
                  rows="2">{{ old('billing_address', $location->billing_address) }}</textarea>
    </div>

</div>

<hr>

{{-- ================= REPORTING ================= --}}
<h6 class="mb-3 text-primary">Reporting Structure</h6>
<div class="row g-3">

    <div class="col-md-6">
        <label>Reporting Location</label>
        <select name="reporting_location_id" class="form-control">
            <option value="">-- None --</option>
            @foreach(App\Models\Location::get() as $loc)
                <option value="{{ $loc->id }}"
                    {{ $location->reporting_location_id == $loc->id ? 'selected' : '' }}>
                    {{ $loc->name }} ({{ $loc->type }})
                </option>
            @endforeach
        </select>
    </div>

    <div class="col-md-6">
        <label>Status <span class="text-danger">*</span></label>
        <select name="status" class="form-control" required>
            @foreach(['Active','Temporarily Closed','Inactive'] as $status)
                <option value="{{ $status }}"
                    {{ $location->status === $status ? 'selected' : '' }}>
                    {{ $status }}
                </option>
            @endforeach
        </select>
    </div>

</div>

<hr>

<div class="text-end">
    <button type="submit" class="btn btn-success">Update Location</button>
    <a href="{{ route('locations') }}" class="btn btn-secondary">Cancel</a>
</div>

</form>
</div>
</div>

</div>
</div>
<script>
       // Update
        $('#editlocationsForm').on('submit', function(e) {
            e.preventDefault();
        
            $.ajax({
               url: "{{ url('update-locations') }}",
                method: 'POST',
                data: new FormData(this),
                processData: false,
                contentType: false,
                success: function(res) {
                    Swal.fire({
                        icon: 'success',
                        title: res.success,
                        showConfirmButton: false,
                        timer: 1500
                    });
                    $('#editSubCatModal').modal('hide');
                   location.reload();
                }
            });
        });
</script>
@endsection
