@extends('admin.layout.template')
@section('title', 'Add Location')

@section('content')
<div class="page-content">
<div class="container-xxl">

<div class="card">
<div class="card-header">
    <h5>Add Location</h5>
</div>

<div class="card-body">
<form id="addlocationsForm">
@csrf

{{-- ================= BASIC INFO ================= --}}
<h6 class="mb-3 text-primary">Basic Information</h6>
<div class="row g-3">

    <div class="col-md-4">
        <label class="form-label">Location Type <span class="text-danger">*</span></label>
        <select name="type" class="form-control" required>
            <option value="">Select Type</option>
            <option>Warehouse</option>
            <option>Franchise</option>
            <option>Zonal Franchise</option>
            <option>Distributor</option>
            <option>Dealer / Showroom</option>
            <option>Office / Branch</option>
        </select>
    </div>

    <div class="col-md-4">
        <label class="form-label">Business / Location Name <span class="text-danger">*</span></label>
        <input type="text" name="name" class="form-control" required>
    </div>

    <div class="col-md-4">
        <label class="form-label">Display Name <span class="text-danger">*</span></label>
        <input type="text" name="display_name" class="form-control" required>
    </div>

</div>

<hr>

{{-- ================= ADDRESS ================= --}}
<h6 class="mb-3 text-primary">Address Details</h6>
<div class="row g-3">

    <div class="col-md-4">
        <label>City <span class="text-danger">*</span></label>
        <input type="text" name="city" class="form-control" required>
    </div>

    <div class="col-md-4">
        <label>District</label>
        <input type="text" name="district" class="form-control">
    </div>

    <div class="col-md-4">
        <label>State <span class="text-danger">*</span></label>
        <input type="text" name="state" class="form-control" required>
    </div>

    <div class="col-md-4">
        <label>Country <span class="text-danger">*</span></label>
        <input type="text" name="country" value="India" class="form-control" required>
    </div>

    <div class="col-md-4">
        <label>Pincode</label>
        <input type="text" name="pincode" class="form-control">
    </div>

</div>

<hr>

{{-- ================= CONTACT ================= --}}
<h6 class="mb-3 text-primary">Contact Details</h6>
<div class="row g-3">

    <div class="col-md-3">
        <label>Contact Person <span class="text-danger">*</span></label>
        <input type="text" name="contact_person_name" class="form-control" required>
    </div>

    <div class="col-md-3">
        <label>Phone <span class="text-danger">*</span></label>
        <input type="text" name="phone" class="form-control" required>
    </div>

    <div class="col-md-3">
        <label>Alternate Phone</label>
        <input type="text" name="alternate_phone" class="form-control">
    </div>

    <div class="col-md-3">
        <label>Email</label>
        <input type="email" name="email" class="form-control">
    </div>

</div>

<hr>

{{-- ================= LEGAL & BILLING ================= --}}
<h6 class="mb-3 text-primary">Legal & Billing</h6>
<div class="row g-3">

    <div class="col-md-4">
        <label>GST Number</label>
        <input type="text" name="gst_number" class="form-control">
    </div>

    <div class="col-md-4">
        <label>PAN</label>
        <input type="text" name="pan" class="form-control">
    </div>

    <div class="col-md-4">
        <label>Trade License No</label>
        <input type="text" name="trade_license_no" class="form-control">
    </div>

    <div class="col-md-6">
        <label>Billing Name</label>
        <input type="text" name="billing_name" class="form-control">
    </div>

    <div class="col-md-6">
        <label>Billing Address</label>
        <textarea name="billing_address" class="form-control" rows="2"></textarea>
    </div>

</div>

<hr>

{{-- ================= REPORTING ================= --}}
<h6 class="mb-3 text-primary">Reporting Structure</h6>
<div class="row g-3">

    <div class="col-md-6">
        <label>Reporting Location</label>
        <select name="reporting_location_id" class="form-control">
            <option value="">-- None --</option>
            @foreach(App\Models\Location::get() as $loc)
                <option value="{{ $loc->id }}">{{ $loc->name }} ({{ $loc->type }})</option>
            @endforeach
        </select>
    </div>

    <div class="col-md-6">
        <label>Status <span class="text-danger">*</span></label>
        <select name="status" class="form-control" required>
            <option value="Active">Active</option>
            <option value="Temporarily Closed">Temporarily Closed</option>
            <option value="Inactive">Inactive</option>
        </select>
    </div>

</div>

<hr>

<div class="text-end">
    <button type="submit" class="btn btn-success">Save Location</button>
</div>

</form>
</div>
</div>

</div>
</div>
<script>
      $('#addlocationsForm').on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url:"{{ route('save-locations') }}",
            method:"POST",
            data:new FormData(this),
            processData:false,
            contentType:false,
            success:function(res){
                Swal.fire({icon:'success',title:res.success,showConfirmButton:false,timer:1500});
                $('#addlocationsForm')[0].reset();
              
            }
        });
    });
</script>
@endsection
