@extends('admin.layout.template')
@section('title','Settings')

@section('content')
<div class="page-content">
    <div class="container-xxl">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Settings</h4>
                    </div>
                    <div class="card-body">
                        <ul class="nav nav-tabs mb-3">
                            <li class="nav-item">
                                <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#web">Web Settings</button>
                            </li>

                            <li class="nav-item">
                                <button class="nav-link" data-bs-toggle="tab" data-bs-target="#contact">Contact</button>
                            </li>

                            <li class="nav-item">
                                <button class="nav-link" data-bs-toggle="tab" data-bs-target="#sections">Home Sections</button>
                            </li>

                            <li class="nav-item">
                                <button class="nav-link" data-bs-toggle="tab" data-bs-target="#videos">Home Videos</button>
                            </li>
                        </ul>

                        <div class="tab-content">


                            <!-- web settings tab -->

                            <div class="tab-pane fade show active" id="web">

                                <form id="webForm">
                                    @csrf
                                    <label class="form-label"> Razropay id</label>
                                    <input name="razropay_key_id" class="form-control mb-3"
                                        value="{{ $webSettings->razropay_key_id ?? '' }}"
                                        placeholder="Razorpay Key">
                                    <label class="form-label">Razropay Key </label>
                                    <input name="razropay_secret_key" class="form-control mb-3"
                                        value="{{ $webSettings->razropay_secret_key ?? '' }}"
                                        placeholder="Secret Key">
                                    <label class="form-label mt-2"> Privacy Policy</label>
                                    <textarea id="privacy_policy" name="privacy_policy" class="form-control mb-3 text-editor">
                                    {{ $webSettings->privacy_policy ?? '' }}
                                    </textarea>

                                    <label class="form-label mt-2"> Terms and conditions</label>
                                    <textarea id="terms_and_conditions" name="terms_and_conditions" class="form-control mb-3 text-editor">
                                    {{ $webSettings->terms_and_conditions ?? '' }}
                                    </textarea>


                                    <button class="btn btn-success mt-2">Save</button>

                                </form>

                            </div>
                            <!-- contact tab -->

                            <div class="tab-pane fade" id="contact">

                                <form id="contactForm">
                                    @csrf

                                    <div class="mb-3">
                                        <label class="form-label">Customer Service</label>
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="fas fa-headset"></i></span>
                                            <input type="text" name="customer_service" class="form-control"
                                                value="{{ $contactSettings->customer_service ?? '' }}">
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Whatsapp</label>
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="fab fa-whatsapp"></i></span>
                                            <input type="text" name="whatsapp" class="form-control"
                                                value="{{ $contactSettings->whatsapp ?? '' }}">
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Website</label>
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="fas fa-globe"></i></span>
                                            <input type="text" name="website" class="form-control"
                                                value="{{ $contactSettings->website ?? '' }}">
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Facebook</label>
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="fab fa-facebook"></i></span>
                                            <input type="text" name="facebook" class="form-control"
                                                value="{{ $contactSettings->facebook ?? '' }}">
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Twitter</label>
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="fab fa-twitter"></i></span>
                                            <input type="text" name="twitter" class="form-control"
                                                value="{{ $contactSettings->twitter ?? '' }}">
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Instagram</label>
                                        <div class="input-group">
                                            <span class="input-group-text"><i class="fab fa-instagram"></i></span>
                                            <input type="text" name="instagram" class="form-control"
                                                value="{{ $contactSettings->instagram ?? '' }}">
                                        </div>
                                    </div>

                                    <button class="btn btn-success">Save</button>

                                </form>


                            </div>
                            <!-- home section tab -->

                            <div class="tab-pane fade" id="sections">

                                <form id="sectionForm" enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="home_id" value="{{ $sections->id ?? '' }}">

                                    <label class="form-label">Title</label>
                                    <input name="title" class="form-control mb-2"
                                        value="{{ $sections->title ?? '' }}" placeholder="Title">

                                    <label class="form-label">Sub Title</label>
                                    <input name="subtitle" class="form-control mb-2"
                                        value="{{ $sections->subtitle ?? '' }}">

                                    <label class="form-label">Category</label>
                                    <select name="category_id" class="form-control mb-3">

                                        @foreach($categories as $cat)
                                        <option value="{{ $cat->id }}"
                                            {{ ($sections->category_id ?? '') == $cat->id ? 'selected' : '' }}>
                                            {{ $cat->name }}
                                        </option>
                                        @endforeach

                                    </select>

                                    <button type="submit" class="btn btn-success">
                                        {{ $sections ? 'Update Section' : 'Add Section' }}
                                    </button>

                                </form>

                            </div>
                            <!-- video tab -->
                            <div class="tab-pane fade" id="videos">

                           

                                <form id="videoForm" enctype="multipart/form-data">

                                    @csrf

                                    <input type="hidden" name="video_id" id="video_id">

                                    <label class="form-label">Title</label>
                                    <input name="title" id="video_title" class="form-control mb-2">

                                    <label class="form-label">Sub Title</label>
                                    <input name="subtitle" id="video_subtitle" class="form-control mb-2">

                                    <label class="form-label">Button Text</label>
                                    <input name="button_text" id="video_button_text"
                                        class="form-control mb-2">

                                    <label class="form-label">Upload Video</label>
                                    <input type="file" name="video"
                                        class="form-control mb-2"
                                        accept="video/mp4,video/mpeg,video/quicktime,video/webm,video/x-msvideo">

                                    <!-- current video preview -->
                                    <video id="video_preview" width="200"
                                        class="mb-2 d-none" controls></video>

                                    <label class="form-label">Select Product</label>
                                    <select name="product_id" id="video_product"
                                        class="form-control mb-3">

                                        @foreach($products as $p)
                                        <option value="{{ $p->id }}">{{ $p->name }}</option>
                                        @endforeach

                                    </select>

                                    <button class="btn btn-success">Save Video</button>

                                </form>



                                <hr>
                                <h5>Existing Videos</h5>

                                @foreach($videos as $v)

                                <div class="card mb-2 p-2">

                                    <strong>{{ $v->title }}</strong><br>
                                    Product : {{ $v->product->name ?? '-' }}

                                    <br>

                                    <video width="200" controls>
                                        <source src="{{ asset($v->video) }}">
                                    </video>

                                   <button class="edit-btn"
data-video='@json($v)'>Edit</button>


                                </div>

                                @endforeach


                            </div>

                        </div>

                      
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<link rel="stylesheet"
    href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
<script>
  
$(document).ready(function() {
    $('#webForm').submit(function(e) {
        e.preventDefault();

        $.ajax({
            url: "{{ url('/settings/web') }}",
            type: 'POST',
            data: $(this).serialize(),

            success: function(res) {
                Swal.fire('Success', res.success, 'success');
            },

            error: function(xhr) {

                if (xhr.status === 422) {
                    let errors = Object.values(xhr.responseJSON.errors)
                        .map(e => e[0]).join('<br>');
                    Swal.fire('Validation Error', errors, 'error');
                } else {
                    Swal.fire('Error', xhr.responseJSON?.message ?? 'Server Error', 'error');
                }

            }
        });
    });

    $('#contactForm').submit(function(e) {
        e.preventDefault();

        $.ajax({
            url: "{{ url('/settings/contact') }}",
            type: 'POST',
            data: $(this).serialize(),

            success: function(res) {
                Swal.fire('Success', res.success, 'success');
            },

            error: function(xhr) {
                if (xhr.status === 422) {
                    let errors = Object.values(xhr.responseJSON.errors)
                        .map(e => e[0]).join('<br>');
                    Swal.fire('Validation Error', errors, 'error');
                } else {
                    Swal.fire('Error', xhr.responseJSON?.message ?? 'Server Error', 'error');
                }
            }
        });
    });

    $('#sectionForm').submit(function(e) {
        e.preventDefault();
        let formData = new FormData(this);

        $.ajax({
            url: "{{ url('/settings/home-section') }}",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,

            success: function(res) {
                Swal.fire('Success', res.success, 'success');
            },

            error: function(xhr) {
                console.log(xhr.responseText);
            }
        });
    });


    $('#videoForm').submit(function(e) {
        e.preventDefault();

        let formData = new FormData(this);

        $.ajax({
            url: "{{ url('/settings/home-video') }}",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,

            success: function(res) {
                Swal.fire('Success', res.success, 'success');
                $('#videoForm')[0].reset();
            },

            error: function(xhr) {

                if (xhr.status === 422) {
                    let errors = Object.values(xhr.responseJSON.errors)
                        .map(e => e[0]).join('<br>');
                    Swal.fire('Validation Error', errors, 'error');
                } else {
                    Swal.fire('Error',
                        xhr.responseJSON?.message ?? 'Server Error',
                        'error');
                }

            }
        });
    });

    function editVideo(id, title, subtitle, button, video, product) {
        document.getElementById('video_id').value = id;
        document.getElementById('video_title').value = title;
        document.getElementById('video_subtitle').value = subtitle;
        document.getElementById('video_button_text').value = button;
        document.getElementById('video_product').value = product;

        let preview = document.getElementById('video_preview');
        preview.src = video;
        preview.classList.remove('d-none');

        window.scrollTo({
            top: 0,
            behavior: 'smooth'
        });
    }

    document.querySelectorAll('.edit-btn').forEach(btn=>{
btn.onclick=function(){
let data=JSON.parse(this.dataset.video);
editVideo(data.id,data.title,data.subtitle,
data.button_text,data.video,data.product_id);
}
});

    });
</script>

@endsection