@extends('admin.layout.template')
@section('title', 'Roles')
@section('content')
<div class="page-content">
    <div class="container-xxl">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 py-0">
                <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{route('roles.index')}}">Roles</a></li>
            </ol>
        </nav>
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4 class="card-title">Roles</h4>
                <a href="{{ route('roles.create') }}" class="btn btn-primary">+ Add Role</a>
            </div>
            @php
            $moduleOrder = [
            'profile',
            'room',
            'tag',
            'category',
            'subcategory',
            'product',
            'banner',
            'coupon',
            'stock',
            'location',
            'role',
            'user',
            ];
            @endphp

            <div class="card-body">
                <table id="rolesTable" class="table  table-striped table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Role Name</th>
                              <!-- <th>Price Percentage</th> -->
                            <th>Permissions</th>
                            <th width="150">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($roles as $index => $role)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $role->name }}
                                <br>
                                   @if($role->departments->isNotEmpty())
        <small class="text-muted badge-soft-pink ">
          Department:  {{ $role->departments->pluck('name')->join(', ') }}
        </small>
    @else
        <small class="text-muted">No departments</small>
    @endif

                            </td>
                            <!-- <td>{{ $role->price_percentage}}%</td> -->
                            <td>
                                @foreach($role->grouped_permissions as $module => $permissions)
                                <div class="mb-1">
                                    <span class="badge bg-warning text-dark">{{ $module }}</span>
                                    @foreach($permissions as $perm)
                                    <span class="badge bg-info text-dark">
                                        {{ Str::of($perm)
                        ->replace(['add-', 'update-', 'delete-', 'toggle-', '.'], '')
                        ->replace($module, '')
                        ->title() }}
                                    </span>
                                    @endforeach
                                </div>
                                @endforeach
                            </td>


                            <td>
                                <a href="{{ route('roles.edit', $role->id) }}"
                                    class="btn btn-sm btn-warning">
                                    Edit
                                </a>

                                @if($role->name !== 'Super Admin')
                                <button class="btn btn-sm btn-danger delete-role"
                                    data-id="{{ $role->id }}">
                                    Delete
                                </button>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

        </div>

    </div>
</div>
<!-- Bootstrap JS -->
<!-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script> -->

<script>
    
    $(document).on('click', '.delete-role', function() {
        let roleId = $(this).data('id');
        Swal.fire({
            title: 'Are you sure?',
            text: "This role will be permanently deleted!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "{{ url('roles') }}/" + roleId, // Use url() helper
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        _method: 'DELETE'
                    },
                    success: function(res) {
    if (res.status) {   // 👈 checks "status" key
        Swal.fire(
            'Deleted!',
            res.message,
            'success'
        );
        location.reload();
    } else {
        Swal.fire('Error', res.message, 'error');
    }
},

                    error: function(xhr) {
                        Swal.fire(
                            'Error',
                            xhr.responseJSON?.message || 'Something went wrong',
                            'error'
                        );
                    }
                });
            }
        });
    });
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
    tooltipTriggerList.map(t => new bootstrap.Tooltip(t))

    $(document).ready(function() {
        $('#rolesTable').DataTable({
            pageLength: 10,
            ordering: true,
            responsive: true
        });
    });


</script>
@endsection