@extends('admin.layout.template')

@section('title','Edit Role')

@section('content')

<div class="page-content">
    <div class="container-xxl">

        <form id="editRoleForm">
            @csrf

            {{-- Role Info --}}
            <div class="card mb-4">
                <div class="card-header">
                    <h4>Edit Role</h4>
                </div>
                <div class="card-body row">
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Role Name</label>
                        <input type="text"
                            name="role_name"
                            class="form-control"
                            value="{{ old('role_name', $role->name) }}"
                            required>
                    </div>
                    <!-- <div class="col-md-2 mb-3">
                        <label class="form-label">Price Percentage</label>
                        <div class="input-group mb-3">
                            <input type="number"
                                name="price_percentage"
                                class="form-control"
                                value="{{ old('price_percentage	', $role->price_percentage	) }}"
                                required>
                            <span class="input-group-text fs-20">
                                %
                            </span>

                        </div>
                    </div> -->
                    <div class="col-md-8 mb-3">
                        <label class="form-label">Departments</label>
                        <select name="department_ids[]" class="form-control" multiple data-choices>
                            @foreach($departments as $dept)
                            <option value="{{ $dept->id }}"
                                {{ in_array($dept->id, $roleDepartmentIds) ? 'selected' : '' }}>
                                {{ $dept->name }}
                            </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-12 mt-2">
                        <div class="form-check">
                            <input type="checkbox"
                                name="is_locked"
                                class="form-check-input"
                                id="is_locked"
                                {{ $role->is_locked ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_locked">
                                Lock this role (System Role)
                            </label>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Permissions --}}
            @foreach($permissions as $module => $perms)
            <div class="card mb-3 p-3">

                <div class="d-flex justify-content-between mb-2">
                    <h4 class="text-lg font-semibold text-blue-600">
                        {{ ucfirst($module) }}
                    </h4>
                    <div class="form-check">
                        <input type="checkbox"
                            class="form-check-input select-all"
                            data-module="{{ $module }}">
                        <label class="form-check-label">Select All</label>
                    </div>
                </div>

                <div class="row fw-semibold border-bottom pb-2 mb-2">
                    <div class="col-4">Module</div>
                    <div class="col-2 text-center">Add</div>
                    <div class="col-2 text-center">View</div>
                    <div class="col-2 text-center">Update</div>
                    <div class="col-2 text-center">Delete</div>
                </div>

                @php
                $actions = ['add','view','update','delete'];

                $actionAliases = [
                'add' => ['add','create','store'],
                'view' => ['view','index','show'],
                'update' => ['update','edit'],
                'delete' => ['delete','destroy'],
                ];

                $normalize = fn($v) => strtolower(str_replace(['-','.','_'],'',$v));
                @endphp

                <div class="row align-items-center py-2 permission-row">
                    <div class="col-4 text-capitalize fw-semibold">
                        {{ str_replace('-', ' ', $module) }}
                    </div>

                    @foreach($actions as $action)
                    @php
                    $permissionName = null;

                    $moduleVariants = [$module, \Illuminate\Support\Str::plural($module)];

                    foreach ($perms as $perm) {
                    $permNorm = $normalize($perm);

                    foreach ($moduleVariants as $mod) {
                    $modNorm = $normalize($mod);

                    if (!str_contains($permNorm, $modNorm)) continue;

                    foreach ($actionAliases[$action] as $alias) {
                    if (str_contains($permNorm, $normalize($alias))) {
                    $permissionName = $perm;
                    break 3;
                    }
                    }

                    if (
                    $action === 'view' &&
                    ($permNorm === $modNorm || str_ends_with($perm, '.index'))
                    ) {
                    $permissionName = $perm;
                    break 2;
                    }
                    }
                    }
                    @endphp

                    <div class="col-2 text-center">
                        @if($permissionName)
                        <input type="checkbox"
                            class="form-check-input permission-checkbox module-{{ $module }}"
                            name="permissions[]"
                            value="{{ $permissionName }}"
                            {{ in_array($permissionName, $rolePermissions) ? 'checked' : '' }}>
                        @endif
                    </div>
                    @endforeach
                </div>



            </div>
            @endforeach

            <div class="text-end mb-5">
                <button type="submit" class="btn btn-primary">
                    Update Role
                </button>
            </div>
        </form>
    </div>
</div>


<script>
    /* Select All per module */
    document.querySelectorAll('.select-all').forEach(selectAll => {
        selectAll.addEventListener('change', function() {
            let module = this.dataset.module;
            document
                .querySelectorAll('.module-' + module)
                .forEach(cb => cb.checked = this.checked);
        });
    });

    /* Submit Edit */
    $('#editRoleForm').on('submit', function(e) {
        e.preventDefault();

        Swal.fire({
            title: 'Are you sure?',
            text: 'Do you want to update this role?',
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: 'Yes, update it',
            cancelButtonText: 'Cancel'
        }).then((result) => {

            if (!result.isConfirmed) return;

            $.ajax({
                url: "{{ route('roles.update', $role->id) }}",
                type: 'POST',
                data: $(this).serialize(),
                success: function(res) {
                    if (res.status) {
                        Swal.fire('Updated!', res.message, 'success')
                            .then(() => {
                                window.location.href = "{{ route('roles.index') }}";
                            });
                    } else {
                        Swal.fire('Error', res.message, 'error');
                    }
                },
                error: function(xhr) {
                    console.log('AJAX ERROR:', xhr); // 👈 DEBUG

                    if (xhr.status === 422) {
                        let errors = xhr.responseJSON.errors;
                        let msg = Object.values(errors).flat().join('<br>');
                        Swal.fire('Validation Error', msg, 'error');
                    } else if (xhr.status === 419) {
                        Swal.fire('Session Expired', 'Please refresh the page', 'warning');
                    } else {
                        Swal.fire(
                            'Error',
                            xhr.responseJSON?.message || 'Server error',
                            'error'
                        );
                    }
                }
            });
        });
    });


    document.querySelectorAll('.scope-type').forEach(select => {
        select.addEventListener('change', function() {
            let module = this.dataset.module;

            document.querySelectorAll(`[id^="scope-"][id$="-${module}"]`)
                .forEach(el => el.classList.add('d-none'));

            if (this.value !== 'all' && this.value !== 'own_only') {
                document
                    .getElementById(`scope-${this.value}-${module}`)
                    ?.classList.remove('d-none');
            }
        });
    });
</script>


@endsection