@extends('admin.layout.template')
@section('title', 'Project Details')
@section('content')

<div class="page-content">
    <div class="container-xxl">

        <div class="card">
            <div class="card-header">
                <h4>Quotation List</h4>
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table class="table align-middle table-hover table-centered" id="quotationTable">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Quotation No</th>
                                <th>Project</th>
                                <th>Subtotal</th>
                                <th>Tax</th>
                                <th>Total</th>
                                <th>Status</th>
                                <th>Expected Completion date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<script>
    $(function() {

        $('#quotationTable').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('quotations.list') }}",
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'quotation_number'
                },
                {
                    data: 'project_name'
                },
                {
                    data: 'subtotal'
                },
                {
                    data: 'tax'
                },
                {
                    data: 'amount'
                },
                {
                    data: 'status_badge'
                },
                {
                    data: 'expected_completion_date'
                },
                {
                    data: 'action',
                    orderable: false,
                    searchable: false
                }
            ]
        });

    });


    $(document).on('click', '.deleteBtn', function() {

        let url = $(this).data('url');

        Swal.fire({
            title: 'Are you sure?',
            text: "This quotation will be deleted!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {

            if (result.isConfirmed) {

                $.ajax({
                    url: url,
                    type: 'DELETE',
                    data: {
                        _token: '{{ csrf_token() }}'
                    },
                    success: function(res) {

                        Swal.fire('Deleted!', res.message, 'success');
                        $('#quotationTable').DataTable().ajax.reload();
                    }
                });
            }
        });
    });
</script>
@endsection