@extends('admin.layout.template')
@section('title', 'Projects')
@section('content')

<div class="page-content">
    <div class="container-xxl">

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Project List - (Total: {{App\Models\Project::count()}})</h4>
            </div>
            <div class="card-body">
                <table class="table table-hover" id="projectsTable">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Project Number</th>
                            <th>Name</th>
                            <th>Customer</th>
                            <th>Expected Completion</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                </table>

            </div>
        </div>

    </div>
</div>

<script>
$(document).ready(function() {

    $('#projectsTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ route('projects.data') }}",
        columns: [
            { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable:false, searchable:false },
            { data: 'project_number', name: 'project_number' },
            { data: 'project_name', name: 'project_name' },
            { data: 'customer_name', name: 'customer_name' },
            { data: 'expected_completion_date', name: 'expected_completion_date' },
            { data: 'actions', name: 'actions', orderable:false, searchable:false }
        ]
    });

});
</script>


@endsection