<form class="variant-form-add needs-validation mb-4" novalidate>
    @csrf

    <input type="hidden" name="product_id" value="{{ $product->id }}">

    <div class="card p-3 border">
        <div class="d-flex justify-content-between align-items-center mb-2">
            <h5 class="mb-0">
                Add new Variant
            </h5>
        </div>

        <div class="card p-3">
            <h5>Variant / SKU Details</h5>

            <div class="row g-3">

                <div class="col-md-3">
                    <label>SKU *</label>
                    <input type="text" name="sku" class="form-control" required>
                </div>

                <div class="col-md-3">
                    <label>Batch No</label>
                    <input type="text" name="batch_no" class="form-control">
                </div>
                <div class="col-md-3">
                    <label>Material / Fabric Composition</label>
                    <input type="text" name="material_or_fabric_composition" class="form-control"
                        placeholder="Cotton 60% + Polyester 40%">
                </div>

                <div class="col-md-3">
                    <label>Pattern</label>
                    <input type="text" name="pattern" class="form-control"
                        placeholder="Plain / Floral / Geometric">
                </div>
      @if($product->category->name == 'Mattress')

                                <div class="card mt-3 p-3 border">
                                    <h5>Mattress Configuration</h5>

                                    <div class="row">

                                        <div class="col-md-3">
                                            <label>Size Category</label>
                                            <select name="mattress_size_category[]" class="form-control size-category">
                                                <option value="">Select</option>
                                                <option value="single"
                                                   >
                                                    Single</option>
                                                <option value="diwan"
                                                   >
                                                    Diwan</option>
                                                <option value="queen"
                                                   >
                                                    Queen</option>
                                                <option value="king"
                                                  >King
                                                </option>
                                            </select>
                                        </div>

                                        <div class="col-md-3">
                                            <label>Length (inch)</label>
                                            <input type="number" step="0.01" name="mattress_length_inch[]"
                                                class="form-control length"
                                                >
                                        </div>

                                        <div class="col-md-3">
                                            <label>Width (inch)</label>
                                            <input type="number" step="0.01" name="mattress_width_inch[]"
                                                class="form-control width" >
                                        </div>

                                        <div class="col-md-3">
                                            <label>Thickness (inch)</label>
                                            <input type="number" step="0.01" name="mattress_thickness_inch[]"
                                                class="form-control" >
                                        </div>

                                    </div>
                                </div>


                                @endif
                <div class="col-md-3">
                    <label>Unit *</label>
                    <select name="unit" class="form-control" required>
                        @foreach(['cm','inch','ft','mtr','sqft','nos'] as $unit)
                        <option value="{{ $unit }}">
                            {{ $unit }}
                        </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-3">
                    <label>Length</label>
                    <input type="number" name="dimensions[length]"
                        class="form-control">
                </div>

                <div class="col-md-3">
                    <label>Width</label>
                    <input type="number" name="dimensions[width]"
                        class="form-control">
                </div>

                <div class="col-md-3">
                    <label>Height</label>
                    <input type="number" name="dimensions[height]"
                        class="form-control">
                </div>


                <div class="col-md-3">
                    <label>Color Name</label>
                    <input type="text" name="color_name" class="form-control">
                </div>

                <div class="col-md-3">
                    <label>Color Code</label>
                    <input type="color" name="color_code" class="form-control">
                </div>
                <div class="col-md-3">
                    <label>Design Repeat</label>
                    <input type="text" name="design_repeat" value="0"
                        class="form-control">
                </div>
                <div class="col-md-3">
                    <label>GSM</label>
                    <input type="number" step="0.01" name="gsm" class="form-control">
                </div>

                <div class="col-md-2">
                    <label>Weight (kg)</label>
                    <input type="number" step="0.01" name="weight" class="form-control">
                </div>

                <div class="col-md-2">
                    <label>Rub Count</label>
                    <input type="number" name="rub_count" class="form-control">
                </div>

                <div class="col-md-2">
                    <label>MOQ</label>
                    <input type="number" name="moq" class="form-control">
                </div>

                <div class="col-md-3">
                    <label>MRP *</label>
                    <input type="number" name="mrp" class="form-control" required>
                </div>

                <div class="col-md-3">
                    <label>Offer Price *</label>
                    <input type="number" name="offer_price" class="form-control" required>
                </div>

            </div>
        </div>

        <div class="text-end mt-3">
            <button type="submit"
                class="btn btn-primary btn-sm">
                Save Variant
            </button>
        </div>
    </div>
</form>