@extends('admin.layout.template')
@section('title', 'Sub Category')
@section('content')

<div class="page-content">
    <div class="container-xxl">

        <!-- Add Form -->
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between">
                <h5>Add Sub Category</h5>
            </div>
            <div class="card-body">
                <form id="addSubCategoryForm" enctype="multipart/form-data">
                    @csrf
                    <div class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label">Main Category</label>
                            <select name="category_id" class="form-control" required>
                                <option value="">Select Category</option>
                                @foreach(App\Models\Category::get() as $cat)
                                <option value="{{$cat->id}}">{{$cat->name}}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">Sub Category Name</label>
                            <input type="text" name="name" class="form-control" placeholder="Enter subcategory name" required>
                        </div>



                        <!-- Image Upload -->
                        <div class="col-lg-4">
                            <div class="mb-3">
                                <label class="form-label fw-medium">Upload Image</label>
                                <input type="file" required
                                    name="photo"
                                    class="form-control image-input"
                                    accept="image/*">
                            </div>
                        </div>

                        <!-- Image Preview -->
                        <div class="col-lg-2 text-center">
                            <label class="form-label fw-medium d-block">Preview</label>

                            <div class="preview-box">
                                <img id="previewImage"
                                    src="{{ asset('assets/images/default-category.JPG') }}"
                                    class="img-fluid shadow-sm"
                                    alt="Preview">
                            </div>
                        </div>
                    </div>
                    <div class="text-start mt-3">
                        <button type="submit" class="btn btn-success">Save</button>
                    </div>
                </form>
            </div>
        </div>

        <!-- DataTable -->
        <div class="card">
            <div class="card-body table-responsive">
                <table class="table table-bordered align-middle text-center">
                    <thead class="table-light">
                        <tr>
                            <th>SL.NO</th>
                            <th>Sub Category</th>
                            <th>Main Category</th>
                            <th>Image</th>
                            <th>Status</th>
                            <th>Model</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editSubCatModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="editSubCategoryForm" enctype="multipart/form-data" class="needs-validation" novalidate>
                @csrf
                <div class="modal-header">
                    <h5>Edit Sub Category</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="id" id="edit_id">
                    <div class="mb-3">
                        <label>Main Category</label>
                        <select name="category_id" id="edit_category" class="form-control" required>
                            @foreach(App\Models\Category::get() as $cat)
                            <option value="{{$cat->id}}">{{$cat->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label>Name</label>
                        <input type="text" name="name" id="edit_name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Image</label>
                        <input type="file"
                            name="photo"
                            class="form-control subcat-image-input"
                            accept="image/*"
                            data-preview="editSubPreview">

                        <div class="mt-2 text-center">
                            <img id="editSubPreview"
                                src="{{ asset('images/no-image.png') }}"
                                style="height:80px;border-radius:8px;border:1px solid #ddd;">
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button class="btn btn-success" type="submit">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modelModal">
    <div class="modal-dialog">
        <div class="modal-content">

            <form id="modelForm">
                @csrf
                <input type="hidden" name="category_id" id="category_id">

                <div class="modal-header">
                    <h5 class="modal-title">Add Models</h5>
                </div>

                <div class="modal-body">

                    <label>Models (comma separated)</label>

                    <input type="text"
                           name="models"
                           id="models"
                           class="form-control"
                           placeholder="Pleated, Eyelet, Ripple">

                </div>

                <div class="modal-footer">
                    <button class="btn btn-primary">Save</button>
                </div>

            </form>

        </div>
    </div>
</div>

<script>
    $(function() {
        var table = $('.table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('get-subcategory') }}",
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'category',
                    name: 'category'
                },
                {
                    data: 'image',
                    name: 'image'
                },
                {
                    data: 'status',
                    name: 'status'
                },
                 {
                    data: 'model',
                    name: 'model'
                },
                {
                    data: 'action',
                    name: 'action'
                },
            ],
        });

        // Add
        $('#addSubCategoryForm').on('submit', function(e) {
            e.preventDefault();
            $.ajax({
                url: "{{ route('add-subcategory') }}",
                method: "POST",
                data: new FormData(this),
                processData: false,
                contentType: false,
                success: function(res) {
                    Swal.fire({
                        icon: 'success',
                        title: res.success,
                        showConfirmButton: false,
                        timer: 1500
                    });
                    $('#addSubCategoryForm')[0].reset();
                    table.ajax.reload();
                }
            });
        });

        // Edit open
        $(document).on('click', '.editSubCategory', function() {
            $('#edit_id').val($(this).data('id'));
            $('#edit_name').val($(this).data('name'));
            $('#edit_category').val($(this).data('category'));

            let image = $(this).data('image');
            $('#editSubPreview').attr('src', image);

            $('#editSubCatModal').modal('show');
        });


        // Update
        $('#editSubCategoryForm').on('submit', function(e) {
            e.preventDefault();
            var id = $('#edit_id').val();
            $.ajax({
                url: "{{ url('update-subcategory') }}/" + id,
                method: 'POST',
                data: new FormData(this),
                processData: false,
                contentType: false,
                success: function(res) {
                    Swal.fire({
                        icon: 'success',
                        title: res.success,
                        showConfirmButton: false,
                        timer: 1500
                    });
                    $('#editSubCatModal').modal('hide');
                    table.ajax.reload();
                }
            });
        });

        // Delete
        $(document).on('click', '.deleteSubCategory', function() {
            var id = $(this).data('id');
            Swal.fire({
                title: 'Are you sure?',
                text: 'You will not be able to revert this!',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "{{ url('delete-subcategory') }}/" + id,
                        method: 'DELETE',
                        data: {
                            _token: '{{csrf_token()}}'
                        },
                        success: function(res) {
                            Swal.fire({
                                icon: 'success',
                                title: res.success,
                                showConfirmButton: false,
                                timer: 1500
                            });
                            table.ajax.reload();
                        }
                    });
                }
            });
        });

        // Status Toggle
  $(document).on('change', '.toggleStatus', function () {

    let checkbox = $(this);
    let id = checkbox.data('id');
    let status = checkbox.prop('checked') ? 'activate' : 'deactivate';

    Swal.fire({
        title: 'Are you sure?',
        text: `Do you want to ${status} this subcategory?`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d4af37',
        cancelButtonColor: '#6b7280',
        confirmButtonText: 'Yes, proceed',
        cancelButtonText: 'Cancel'
    }).then((result) => {

        if (result.isConfirmed) {

            $.ajax({
                url: "{{ url('toggle-subcategory-status') }}/" + id,
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}'
                },
                beforeSend: function () {
                    $("#globalLoader").fadeIn(100);
                },
                success: function (res) {
                    $("#globalLoader").fadeOut(150);

                    Swal.fire({
                        icon: 'success',
                        title: 'Updated!',
                        text: res.success,
                        timer: 1500,
                        showConfirmButton: false
                    });
                },
                error: function () {
                    $("#globalLoader").fadeOut(150);

                    checkbox.prop('checked', !checkbox.prop('checked'));

                    Swal.fire({
                        icon: 'error',
                        title: 'Failed',
                        text: 'Something went wrong. Please try again.'
                    });
                }
            });

        } else {
            // revert toggle if cancelled
            checkbox.prop('checked', !checkbox.prop('checked'));
        }
    });
});

    $(document).on('click','.addmodel',function(e){
    e.preventDefault();

    let id = $(this).data('id');
    let models = $(this).data('models');

    $('#category_id').val(id);
    $('#models').val(models);

    $('#modelModal').modal('show');
});
$('#modelForm').submit(function(e){
    e.preventDefault();

    $.ajax({
         url:"{{ route('save-models') }}",
        type:'POST',
        data:$(this).serialize(),

        success:function(res){
            Swal.fire('Success',res.success,'success');
            $('#modelModal').modal('hide');
            location.reload();
        },

        error:function(xhr){
            Swal.fire('Error','Something went wrong','error');
            console.log(xhr.responseText);
        }
    });
});
    });
</script>

@endsection