@extends('admin.layout.template')
@section('title', 'Rooms')
@section('content')

<div class="page-content">

    <!-- Start Container Fluid -->
    <div class="container-xxl">

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title d-flex align-items-center gap-1"><iconify-icon icon="solar:settings-bold-duotone" class="text-primary fs-20"></iconify-icon>Add room</h4>
                    </div>
                    <div class="card-body">
                        <form id="addroom">
                            @csrf
                            <div class="row align-items-end">

                                <!-- Category Name -->
                                <div class="col-lg-5">
                                    <div class="mb-3">
                                        <label class="form-label fw-medium">Room</label>
                                        <input type="text"
                                            name="name"
                                            class="form-control"
                                            placeholder="Enter room name"
                                            required>
                                    </div>
                                </div>

                                <!-- Image Upload -->
                                <div class="col-lg-5">
                                    <div class="mb-3">
                                        <label class="form-label fw-medium">Upload Image</label>
                                        <input type="file" required
                                            name="photo" accept="image/*"
                                            class="form-control image-input"
                                            accept="image/*">
                                    </div>
                                </div>

                                <!-- Image Preview -->
                                <div class="col-lg-2 text-center">
                                    <label class="form-label fw-medium d-block">Preview</label>

                                    <div class="preview-box">
                                        <img id="previewImage"
                                            src="{{ asset('assets/images/default.jpg') }}"
                                            class="img-fluid shadow-sm"
                                            alt="Preview">
                                    </div>
                                </div>

                            </div>
                            <div class="text-end mt-4">
                                <button type="submit" class="btn btn-success px-4">
                                    Add Room
                                </button>
                            </div>

                        </form>
                    </div>
                </div>


                <div class="row">
                    <div class="col-xl-12">
                        <div class="card">

                            <div class="card-body p-0">
                                <div class="table-responsive">
                                    <table class="table align-middle mb-0 table-hover table-centered">
                                        <thead class="bg-light-subtle">
                                            <tr>
                                                <th>SL.NO</th>
                                                <th>Room Name</th>
                                                <th>Image</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                                <!-- end table-responsive -->
                            </div>

                        </div>
                    </div>

                </div>


            </div>
        </div>
    </div>
</div>


<script>
    $(function() {

      var table =   $('.table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('get-room') }}",
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex'
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'image',
                    name: 'image'
                },

                {
                    data: 'action',
                    name: 'action'
                },

            ],
            "select": {
                'style': 'multi',
                'selector': 'td:first-child' //only checkbox can select row 
            },
        });

        // SweetAlert Delete Confirmation
        $(document).on('click', '.deleteroom', function(e) {
            e.preventDefault(); // 🔥 stop page reload or navigation
            var id = $(this).data('id');

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'Cancel',
                customClass: {
                    popup: 'rounded-3 shadow-lg'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "{{ url('delete-room') }}/" + id,
                        type: 'DELETE',
                        data: {
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(response) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Deleted!',
                                text: response.success,
                                showConfirmButton: false,
                                timer: 1500
                            });
                            $('.table').DataTable().ajax.reload();
                        },
                        error: function() {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error!',
                                text: 'Something went wrong while deleting.',
                            });
                        }
                    });
                }
            });
        });


        // EDIT (inline)
        $(document).on('click', '.editroom', function(e) {
            e.preventDefault();

            var row = $(this).closest('tr');
            var id = $(this).data('id');
            var name = row.find('td:eq(1)').text().trim();
            var imgSrc = row.find('td:eq(2) img').attr('src'); // IMAGE COLUMN INDEX

            row.find('td:eq(1)').html(
                '<input type="text" class="form-control form-control-sm edit-name" value="' + name + '">'
            );

            // Image input + preview
            row.find('td:eq(2)').html(`
        <input type="file"
               class="form-control form-control-sm edit-image"
               accept="image/*"
               data-preview="preview-${id}">
        <div class="mt-2 text-center">
            <img src="${imgSrc}"
                 id="preview-${id}"
                 style="height:60px;border-radius:8px;border:1px solid #ddd;">
        </div>
    `);
            $(this).replaceWith(`
        <button class="btn btn-sm btn-success saveroom" data-id="${id}">Save</button>
        <button class="btn btn-sm btn-secondary cancelEdit ms-1">Cancel</button>
    `);
        });


        $(document).on('change', '.edit-image', function() {
            const previewId = $(this).data('preview');
            const file = this.files[0];

            if (file) {
                $('#' + previewId).attr('src', URL.createObjectURL(file));
            }
        });
        // CANCEL edit
        $(document).on('click', '.cancelEdit', function(e) {
            e.preventDefault();
            $('.table').DataTable().ajax.reload();
        });

        // Save inline edit
        $(document).on('click', '.saveroom', function() {
            var id = $(this).data('id');
            var row = $(this).closest('tr');
            //  var name = row.find('td:eq(1) input').val();
            //        var photoFile = row.find('td:eq(3) input[type=file]')[0].files[0];
            var name = row.find('.edit-name').val();
            var photoFile = row.find('.edit-image')[0]?.files[0];
            var formData = new FormData();
            formData.append('_token', '{{ csrf_token() }}');
            formData.append('_method', 'PUT');
            formData.append('name', name);

            if (photoFile) {
                formData.append('photo', photoFile);
            }

            $.ajax({
                url: "{{ url('update-room') }}/" + id,
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                success: function(response) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Updated!',
                        text: response.success,
                        timer: 1500,
                        showConfirmButton: false
                    });
                    table.ajax.reload();
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    let errMsg = '';
                    $.each(errors, function(k, v) {
                        errMsg += v + '\n';
                    });
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops!',
                        text: errMsg
                    });
                }
            });
        });
        // SAVE (update via AJAX)
   

    });
</script>
<script>
$(document).ready(function () {

    $('#addroom').on('submit', function (e) {
        e.preventDefault();

        let form = this;
        let formData = new FormData(form);

        $.ajax({
            url: "{{ route('add-room') }}", // OR url('add-room')
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,

            success: function (response) {
                Swal.fire({
                    icon: 'success',
                    title: 'Success!',
                    text: response.success,
                    timer: 1500,
                    showConfirmButton: false
                });

                // Reset form
                $('#addroom')[0].reset();

                // Reset preview image
                $('#previewImage').attr(
                    'src',
                    "{{ asset('assets/images/default.jpg') }}"
                );

                // If you use datatable
                if (typeof table !== 'undefined') {
                    table.ajax.reload();
                }
                location.reload();
            },

            error: function (xhr) {
                let errMsg = '';

                if (xhr.status === 422) {
                    let errors = xhr.responseJSON.errors;
                    $.each(errors, function (key, value) {
                        errMsg += value[0] + '\n';
                    });
                } else {
                    errMsg = xhr.responseJSON.message ?? 'Something went wrong!';
                }

                Swal.fire({
                    icon: 'error',
                    title: 'Oops!',
                    text: errMsg
                });
            }
        });
    });

});
</script>


@endsection