@extends('admin.layout.template')
@section('title','Order Details')

@section('content')
<style>
    .bg-body {
        background-color: #edebe5 !important;
    }
</style>
<div class="page-content">
    <div class="container-xxl">

        <div class="row">

            {{-- LEFT SIDE --}}
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="fw-bold text-danger">
                            Project Order
                        </h4>

                        <hr>

                        <div class="row">
                            <div class="col-md-6">
                                <p><strong>Project Number:</strong>
                                  <a href="{{route('projects.show', $order->project->id)}}" class="text-success">  {{ $order->project->project_number }}</a>
                                </p>

                                <p><strong>Project Name:</strong>
                                    {{ $order->project->project_name }}
                                </p>

                                <p><strong>Status:</strong>
                                    {{ ucfirst($order->status) }}
                                </p>
                            </div>

                            <div class="col-md-6">
                                <p><strong>Customer:</strong>
                                    {{ $order->user->name }}
                                </p>

                                <p><strong>Total Amount:</strong>
                                    ₹{{ number_format($order->total_amount, 2) }}
                                </p>
                            </div>
                        </div>

                        <hr>

                        <div class="alert alert-info">
                            This order is linked to a project. Product details are managed inside the project module.
                        </div>

                    </div>
                </div>

               
            </div>
        </div>

    </div>
</div>
</div>




@endsection