@extends('admin.layout.template')
@section('title','Order Returns')

@section('content')
<div class="page-content">
    <div class="container-xxl mt-3">

        <div class="card">
            <div class="card-header">
                <h4>Order Return List</h4>
            </div>

            <div class="card-body">

                <div class="table-responsive">
                    <table class="table align-middle mb-0 table-hover table-centered">
                        <thead>
                            <tr>
                                <th>SL</th>
                                <th>Order Number</th>
                                <th>Reason</th>
                                <th>Description</th>
                                <th>Image</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>


    <!-- STATUS MODAL -->
    <div class="modal fade" id="statusModal">
        <div class="modal-dialog">
            <div class="modal-content">

                <div class="modal-header">
                    <h5>Change Status</h5>
                </div>

                <div class="modal-body">
                    <input type="hidden" id="return_id">
                    <select id="return_status" class="form-control">
                        <option value="pending">Pending</option>
                        <option value="approved">Approved</option>
                        <option value="rejected">Rejected</option>
                    </select>
                </div>

                <div class="modal-footer">
                    <button class="btn btn-primary" id="saveStatus">Update</button>
                </div>

            </div>
        </div>
    </div>
</div>


<!-- Image Preview Modal -->
<div class="modal fade" id="imagePreviewModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered modal-xl">
        <div class="modal-content">
            <div class="modal-body text-center">
                <img id="previewImg" src="" class="img-fluid rounded">
            </div>
        </div>
    </div>
</div>

<script>
    $(function() {

        var table = $('.table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('get-order-returns') }}",
            columns: [{
                    data: 'DT_RowIndex',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'order_number'
                },
                {
                    data: 'return_reason'
                },
                {
                    data: 'description'
                },
                {
                    data: 'image',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'status',
                    orderable: false
                },
                {
                    data: 'action',
                    orderable: false,
                    searchable: false
                }
            ]
        });


        // Open Modal
        $(document).on('click', '.changeStatus', function() {
            $('#return_id').val($(this).data('id'));
            $('#return_status').val($(this).data('status'));
            $('#statusModal').modal('show');
        });


        // Update Status
        $('#saveStatus').click(function() {

            $.post("{{ route('order-return-status') }}", {
                _token: '{{ csrf_token() }}',
                id: $('#return_id').val(),
                status: $('#return_status').val()
            }, function(res) {
                $('#statusModal').modal('hide');
                table.ajax.reload();
                Swal.fire('Success', res.success, 'success');
            });

        });


        // Delete
        $(document).on('click', '.deleteReturn', function() {

            let id = $(this).data('id');

            Swal.fire({
                title: 'Are you sure?',
                icon: 'warning',
                showCancelButton: true
            }).then((result) => {

                if (result.isConfirmed) {

                    $.ajax({
                        url: "{{ url('delete-order-return') }}/" + id,
                        type: 'DELETE',
                        data: {
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(res) {
                            table.ajax.reload();
                            Swal.fire('Deleted!', res.success, 'success');
                        }
                    });

                }

            });

        });

    });

    function previewImage(url) {
        document.getElementById('previewImg').src = url;
        var modal = new bootstrap.Modal(document.getElementById('imagePreviewModal'));
        modal.show();
    }
</script>

@endsection