@extends('admin.layout.template')
@section('title', 'Order List')
@section('content')
<style>
    .card-title {
        font-size: 17px;
        font-weight: 500;
        margin: 0;
    }

    .text-primary {
        --bs-text-opacity: 1;
        color: rgb(18 33 118) !important;
    }
</style>
<div class="page-content">
    <div class="container-xxl">

        <div class="row">
            <div class="col-md-6 col-xl-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <h4 class="card-title mb-2">Total Orders</h4>
                                <p class="text-muted fw-medium fs-22 mb-0">{{App\Models\Order::count()}}</p>
                            </div>
                            <div>
                                <div class="avatar-md bg-primary bg-opacity-10 rounded">
                                    <iconify-icon icon="solar:clipboard-remove-broken" class="fs-32 text-primary avatar-title"></iconify-icon>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-xl-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <h4 class="card-title mb-2">Order Placed</h4>
                                <p class="text-muted fw-medium fs-22 mb-0">{{App\Models\Order::where('status','placed')->count()}}</p>
                            </div>
                            <div>
                                <div class="avatar-md bg-primary bg-opacity-10 rounded">
                                    <iconify-icon icon="solar:chat-round-money-broken" class="fs-32 text-primary avatar-title"></iconify-icon>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-xl-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <h4 class="card-title mb-2">Order Processing</h4>
                                <p class="text-muted fw-medium fs-22 mb-0">{{App\Models\Order::where('status','processing')->count()}}</p>
                            </div>
                            <div>
                                <div class="avatar-md bg-primary bg-opacity-10 rounded">
                                    <iconify-icon icon="solar:inbox-line-broken" class="fs-32 text-primary avatar-title"></iconify-icon>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-xl-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <h4 class="card-title mb-2">Order Cancelled</h4>
                                <p class="text-muted fw-medium fs-22 mb-0">{{App\Models\Order::where('status','cancelled')->count()}}</p>
                            </div>
                            <div>
                                <div class="avatar-md bg-primary bg-opacity-10 rounded">
                                    <iconify-icon icon="solar:cart-cross-broken" class="fs-32 text-primary avatar-title"></iconify-icon>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-6 col-xl-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <h4 class="card-title mb-2">Order Shipped</h4>
                                <p class="text-muted fw-medium fs-22 mb-0">{{App\Models\Order::where('status','shipped')->count()}}</p>
                            </div>
                            <div>
                                <div class="avatar-md bg-primary bg-opacity-10 rounded">
                                    <iconify-icon icon="solar:box-broken" class="fs-32 text-primary avatar-title"></iconify-icon>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-6 col-xl-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <h4 class="card-title mb-2">Order Returned</h4>
                                <p class="text-muted fw-medium fs-22 mb-0">{{App\Models\Order::where('status','returned')->count()}}</p>
                            </div>
                            <div>
                                <div class="avatar-md bg-primary bg-opacity-10 rounded">
                                    <iconify-icon icon="solar:tram-broken" class="fs-32 text-primary avatar-title"></iconify-icon>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="col-md-6 col-xl-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <h4 class="card-title mb-2">Order Refund</h4>
                                <p class="text-muted fw-medium fs-22 mb-0">{{App\Models\Order::where('status','refund')->count()}}</p>
                            </div>
                            <div>
                                <div class="avatar-md bg-primary bg-opacity-10 rounded">
                                    <iconify-icon icon="solar:clock-circle-broken" class="fs-32 text-primary avatar-title"></iconify-icon>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-xl-3">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between">
                            <div>
                                <h4 class="card-title mb-2">Delivered</h4>
                                <p class="text-muted fw-medium fs-22 mb-0">{{App\Models\Order::where('status','placed')->count()}}</p>
                            </div>
                            <div>
                                <div class="avatar-md bg-primary bg-opacity-10 rounded">
                                    <iconify-icon icon="solar:clipboard-check-broken" class="fs-32 text-primary avatar-title"></iconify-icon>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

        <div class="row">
            <div class="col-xl-12">

                <div class="card mb-3">
                    <div class="card-header d-flex justify-content-between align-items-center gap-1">
                        <h4 class="card-title flex-grow-1">
                            <iconify-icon icon="solar:box-bold-duotone" class="text-primary fs-20"></iconify-icon>
                            Filter Data
                        </h4>

                    </div>

                    <div class="card-body">
                        <form id="filterForm">
                            <div class="row g-2">

                                <div class="col-md-2">
                                    <label>From Date</label>
                                    <input type="date" name="from_date" class="form-control"
                                        value="{{ date('Y-m-d', strtotime('-1 week')) }}">
                                </div>

                                <div class="col-md-2">
                                    <label>To Date</label>
                                    <input type="date" name="to_date" class="form-control"
                                        value="{{ date('Y-m-d') }}">
                                </div>

                                <div class="col-md-2">
                                    <label>Status</label>
                                    <select name="status" class="form-control">
                                        <option value="">All</option>
                                        <option value="placed">Placed</option>
                                        <option value="processing">Processing</option>
                                        <option value="processing">returned</option>
                                        <option value="shipped">Shipped</option>
                                        <option value="delivered">Delivered</option>
                                        <option value="cancelled">Cancelled</option>
                                        <option value="processing">refund</option>
                                    </select>
                                </div>

                                <div class="col-md-2">
                                    <label>Category</label>
                                    <select name="category_id" class="form-control">
                                        <option value="">All Category</option>
                                        @foreach(App\Models\Category::get() as $cat)
                                        <option value="{{$cat->id}}">
                                            {{$cat->name}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-2">
                                    <label>Subcategory</label>
                                    <select name="subcategory_id" class="form-control">
                                        <option value="">All Subcategory</option>
                                        @foreach(App\Models\SubCategory::get() as $sub)
                                        <option value="{{$sub->id}}">
                                            {{$sub->name}}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <label>Order Type</label>
                                    <select name="order_type" class="form-control">
                                        <option value="">All</option>
                                        <option value="product">Product Order</option>
                                        <option value="project">Project Order</option>
                                    </select>
                                </div>

                                <div class="col-md-12 mt-3">
                                    <button type="button" id="filterBtn"
                                        class="btn btn-primary">
                                        Filter
                                    </button>

                                    <button type="button" id="resetBtn"
                                        class="btn btn-secondary">
                                        Reset
                                    </button>
                                </div>

                            </div>
                        </form>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0 table-hover table-centered">
                                <thead class="bg-light-subtle">
                                    <tr>
                                        <th>SLNO</th>
                                        <th>Order ID</th>
                                        <th>Created at</th>
                                        <th>Customer</th>
                                        <th>Qantity</th>
                                        <th>Total</th>
                                        <th>Payment Status</th>
                                        <!-- <th>Items</th> -->
                                        <th>Delivery Number</th>
                                        <th>Order Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                        <!-- end table-responsive -->
                    </div>

                </div>
            </div>

        </div>

    </div>
</div>


<script>
    $(function() {

        var table = $('.table').DataTable({
            processing: true,
            serverSide: true,

            dom: 'Bfrtip',

            buttons: [{
                    extend: 'copy',
                    text: '<iconify-icon icon="solar:copy-broken"></iconify-icon> Copy',
                    className: 'btn btn-soft-primary btn-sm',
                    exportOptions: {
                        columns: ':not(:last-child)' // Exclude last column
                    }
                },
                {
                    extend: 'csv',
                    text: '<iconify-icon icon="solar:file-text-broken"></iconify-icon> CSV',
                    className: 'btn btn-soft-success btn-sm',
                    exportOptions: {
                        columns: ':not(:last-child)' // Exclude last column
                    }
                },
                {
                    extend: 'pdf',
                    text: '<iconify-icon icon="solar:file-download-broken"></iconify-icon> PDF',
                    className: 'btn btn-soft-danger btn-sm',
                    exportOptions: {
                        columns: ':not(:last-child)' // Exclude last column
                    }
                },
                {
                    extend: 'print',
                    text: '<iconify-icon icon="solar:printer-broken"></iconify-icon> Print',
                    className: 'btn btn-soft-warning btn-sm',
                    exportOptions: {
                        columns: ':not(:last-child)' // Exclude last column
                    }
                }
            ],

            ajax: {
                url: "{{ route('orders.list') }}",
                data: function(d) {
                    d.from_date = $('input[name=from_date]').val();
                    d.to_date = $('input[name=to_date]').val();
                    d.status = $('select[name=status]').val();
                    d.category_id = $('select[name=category_id]').val();
                    d.subcategory_id = $('select[name=subcategory_id]').val();
                    d.order_type = $('select[name=order_type]').val();
                }
            },

            columns: [{
                    data: 'DT_RowIndex',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'order_number'
                },
                {
                    data: 'created_at'
                },
                {
                    data: 'customer'
                },
                {
                    data: 'items_count'
                },
                {
                    data: 'total_amount'
                },
                {
                    data: 'payment_status'
                },

                {
                    data: 'delivery_number'
                },
                {
                    data: 'status'
                },
                {
                    data: 'action'
                }
            ]
        });
        $('#filterBtn').click(function() {
            table.draw();
        });

        $('#resetBtn').click(function() {
            $('#filterForm')[0].reset();
            table.draw();
        });
    });
</script>
@endsection