<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Title Meta -->
    <meta charset="utf-8" />
    <title>@yield('title', 'Default Title')</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="A fully responsive premium admin dashboard template" />
    <meta name="author" content="Techzaa" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <!-- App favicon -->
    <link rel="shortcut icon" href="{{asset('assets/images/logo-light.png')}}">

    <!-- Vendor css (Require in all Page) -->
    <link href="{{asset('assets/css/vendor.min.css')}}" rel="stylesheet" type="text/css" />

    <!-- Icons css (Require in all Page) -->
    <link href="{{asset('assets/css/icons.min.css')}}" rel="stylesheet" type="text/css" />

    <!-- App css (Require in all Page) -->
    <link href="{{asset('assets/css/app.min.css')}}" rel="stylesheet" type="text/css" />
    
<!-- Toastr CSS -->
<link rel="stylesheet"
      href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

    <link rel="stylesheet" type="text/css" href="{{asset('assets/vendor/datatable/jquery.dataTables.min.css')}}">
    <link rel="stylesheet" type="text/css" href="{{asset('assets/vendor/datatable/datatable2/buttons.dataTables.min.css')}}">
    <script src="{{asset('assets/js/jquery-3.6.3.min.js')}}"></script>
    <!-- Theme Config js (Require in all Page) -->
    <script src="{{asset('assets/js/config.js')}}"></script>
    
    <script src="https://cdn.jsdelivr.net/npm/choices.js/public/assets/scripts/choices.min.js"></script>
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/buttons.dataTables.min.css')}}">

<link href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css" rel="stylesheet">


</head>
@if (url()->current() !== url('login') && url()->current() !== url('/'))
@include('admin.layout.menus')
@endif

@yield('content')

@if(!Route::is('roles.create') && !Route::is('roles.edit'))
<!-- ========== Footer Start ========== -->
<footer class="footer">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12 text-center">
                <script>
                    document.write(new Date().getFullYear())
                </script> &copy; Cusella. Crafted by <iconify-icon icon="iconamoon:heart-duotone" class="fs-18 align-middle text-danger"></iconify-icon> <a
                    href="" class="fw-bold footer-text" target="_blank">Amaeka</a>
            </div>
        </div>
    </div>
</footer>
<!-- ========== Footer End ========== -->
 @endif
</div>
<!-- END Wrapper -->
<!-- Vendor Javascript (Require in all Page) -->
<script src="{{asset('assets/js/vendor.js')}}"></script>

<!-- App Javascript (Require in all Page) -->
<script src="{{asset('assets/js/app.js')}}"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script src="{{asset('assets/vendor/datatable/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/js/components/form-quilljs.js')}}"></script>
 <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
    <script type="text/javascript" language="javascript" src="{{asset('assets/js/dataTables.buttons.min.js')}}"></script>
    <script type="text/javascript" language="javascript" src="{{asset('assets/js/buttons.html5.min.js')}}"></script>
    <script type="text/javascript" language="javascript" src="{{asset('assets/js/buttons.print.min.js')}}"></script>
    
<!-- Toastr JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

<script src="https://cdn.ckeditor.com/ckeditor5/39.0.1/classic/ckeditor.js"></script>
<script>
document.querySelectorAll('.text-editor').forEach((editor) => {
    ClassicEditor.create(editor)
    .catch(error => {
        console.error(error);
    });
});
</script>

<script>

$(document).on('change', '.image-input', function () {

    const input = this;
    const preview = $('#previewImage');

    if (input.files && input.files[0]) {

        const file = input.files[0];

        if (!file.type.startsWith('image/')) {
            alert('Please select a valid image');
            input.value = '';
            preview.attr('src', "{{ asset('assets/images/default-brand.JPG') }}");
            return;
        }

        const reader = new FileReader();
        reader.onload = function (e) {
            preview.attr('src', e.target.result);
        };
        reader.readAsDataURL(file);
    }
});


(function () {

    function initChoices(el) {
        if (el._choices) return; // prevent double init

        el._choices = new Choices(el, {
            removeItemButton: true,
            shouldSort: false,
            searchEnabled: true,
            placeholder: true,
            placeholderValue: 'Select options'
        });
    }

    // Init existing
    document.querySelectorAll('select[multiple][data-choices]').forEach(initChoices);

    // Observe future DOM changes (MODALS / AJAX)
    const observer = new MutationObserver(function (mutations) {
        mutations.forEach(function (mutation) {
            mutation.addedNodes.forEach(function (node) {
                if (node.nodeType !== 1) return;

                if (node.matches?.('select[multiple][data-choices]')) {
                    initChoices(node);
                }

                node.querySelectorAll?.('select[multiple][data-choices]')
                    .forEach(initChoices);
            });
        });
    });

    observer.observe(document.body, {
        childList: true,
        subtree: true
    });

})();
</script>

<script>
    

(function () {
    'use strict';

    document.addEventListener('submit', function (event) {
        const form = event.target;
        if (!form.classList.contains('needs-validation')) return;

        let firstInvalid = null;

        [...form.elements].forEach(el => {

            // ✅ SPECIAL HANDLING FOR FILE INPUT
            if (el.type === 'file' && el.required) {
                if (el.files && el.files.length > 0) {
                    el.classList.remove('is-invalid');
                    el.setCustomValidity('');
                    return;
                } else {
                    el.classList.add('is-invalid');
                }
            }

            if (!el.checkValidity()) {
                el.classList.add('is-invalid');

                if (!firstInvalid) firstInvalid = el;

                // Auto-create feedback if not exists
                if (!el.nextElementSibling || !el.nextElementSibling.classList.contains('invalid-feedback')) {
                    const feedback = document.createElement('div');
                    feedback.className = 'invalid-feedback';
                    feedback.innerText = el.dataset.error || 'This field is required';
                    el.after(feedback);
                }
            } else {
                el.classList.remove('is-invalid');
            }
        });

        if (!form.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
            firstInvalid?.scrollIntoView({ behavior: 'smooth', block: 'center' });
        }

        form.classList.add('was-validated');
    }, true);

    // ✅ CLEAR FILE ERROR ON CHANGE
    document.addEventListener('change', function (e) {
        if (e.target.type === 'file') {
            if (e.target.files.length > 0) {
                e.target.classList.remove('is-invalid');
                e.target.setCustomValidity('');
            }
        }
    });
})();

$(document).ajaxError(function(event, jqxhr, settings, thrownError) {
    if (jqxhr.status === 403 && jqxhr.responseJSON?.message) {
        $("#globalLoader").fadeOut(100); // hide loader
        Swal.fire({
            icon: 'error',
            title: 'Access Denied',
            text: jqxhr.responseJSON.message,
            confirmButtonText: 'OK'
        });
    }
});


//  Loader js
$(document).ajaxStart(function () {
    $("#globalLoader").fadeIn(100);
});

$(document).ajaxStop(function () {
    $("#globalLoader").fadeOut(100);
});


</script>

<script>
@if(session('success'))
    toastr.success("{{ session('success') }}");
@endif

@if(session('error'))
    toastr.error("{{ session('error') }}");
@endif

@if(session('warning'))
    toastr.warning("{{ session('warning') }}");
@endif

@if(session('info'))
    toastr.info("{{ session('info') }}");
@endif

@if(session('permission_error'))
    toastr.error("{{ session('permission_error') }}", "Permission Denied");
@endif
</script>



</body>

</html>