<body>
     <!-- loader start -->
     <div id="globalLoader" style="display:none;">
          <div class="loader-backdrop"></div>

          <div class="brand-loader">
               <img src="{{ asset('assets/images/logo-dark.png') }}" class="brand-logo" alt="Cusella">

               <div class="fabric-wave">
                    <span></span>
                    <span></span>
                    <span></span>
               </div>

               <div class="brand-text">TAILORED TO SHINE</div>
          </div>
     </div>

     <!-- loader end -->
     <!-- START Wrapper -->
     <div class="wrapper">

          <!-- ========== Topbar Start ========== -->
          <header class="topbar mb-3">
               <div class="container-fluid">
                    <div class="navbar-header">
                         <div class="d-flex align-items-center">
                              <!-- Menu Toggle Button -->
                              <div class="topbar-item">
                                   <button type="button" class="button-toggle-menu me-2">
                                        <iconify-icon icon="solar:hamburger-menu-broken" class="fs-24 align-middle"></iconify-icon>
                                   </button>
                              </div>

                              <!-- Menu Toggle Button -->
                              <div class="topbar-item">
                                   <h4 class="fw-bold topbar-button pe-none text-uppercase mb-0">@yield('title', 'Default Title')</h4>
                              </div>
                         </div>

                         <div class="d-flex align-items-center gap-1">

                              <!-- Theme Color (Light/Dark) -->
                              @php
                              $user = auth()->user();

                              $notifications = $user->notifications()->latest()->limit(10)->get();
                              $unreadCount = $user->unreadNotifications()->count();
                              @endphp


                              <!-- Notification -->
                              <div class="dropdown topbar-item">
                                   <button type="button" class="topbar-button position-relative" id="page-header-notifications-dropdown" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <iconify-icon icon="solar:bell-bing-bold-duotone" class="fs-24 align-middle"></iconify-icon>
                                        <span class="position-absolute topbar-badge fs-10 translate-middle badge bg-danger rounded-pill">{{ $unreadCount }}<span class="visually-hidden">unread messages</span></span>
                                   </button>
                                   <div class="dropdown-menu py-0 dropdown-lg dropdown-menu-end" aria-labelledby="page-header-notifications-dropdown">
                                        <div class="p-3 border-top-0 border-start-0 border-end-0 border-dashed border">
                                             <div class="row align-items-center">
                                                  <div class="col">
                                                       <h6 class="m-0 fs-16 fw-semibold"> Notifications</h6>
                                                  </div>
                                                  <div class="col-auto">
                                                       <a href="{{ route('notifications.clear') }}"
                                                            onclick="event.preventDefault(); document.getElementById('clear-form').submit();"
                                                            class="text-dark text-decoration-underline">
                                                            <small>Clear All</small>
                                                       </a>

                                                       <form id="clear-form" action="{{ route('notifications.clear') }}" method="POST" class="d-none">
                                                            @csrf
                                                       </form>

                                                  </div>
                                             </div>
                                        </div>
                                        <div data-simplebar style="max-height: 280px;">

                                             @forelse($notifications as $notification)
                                             @php
                                             $data = $notification->data;
                                             $isUnread = is_null($notification->read_at);
                                             @endphp

                                             <a href="javascript:void(0);"
                                                  class="dropdown-item py-3 border-bottom text-wrap {{ $isUnread ? 'bg-soft-light' : '' }}"
                                                  data-id="{{ $notification->id }}">

                                                  <div class="d-flex">

                                                       <!-- Icon / Avatar -->
                                                       <div class="flex-shrink-0">
                                                            <div class="avatar-sm me-2">
                                                                 <span class="avatar-title bg-soft-primary text-primary fs-20 rounded-circle">
                                                                      <iconify-icon icon="solar:bell-bing-bold-duotone"></iconify-icon>
                                                                 </span>
                                                            </div>
                                                       </div>

                                                       <!-- Content -->
                                                       <div class="flex-grow-1">
                                                            <p class="mb-1 fw-semibold">
                                                                 {{ $data['title'] ?? 'Notification' }}
                                                            </p>
                                                            <p class="mb-0 text-muted text-wrap">
                                                                 {{ $data['message'] ?? '' }}
                                                            </p>
                                                            <small class="text-muted">
                                                                 {{ $notification->created_at->diffForHumans() }}
                                                            </small>
                                                       </div>

                                                  </div>
                                             </a>

                                             @empty
                                             <div class="text-center py-4 text-muted">
                                                  No notifications
                                             </div>
                                             @endforelse

                                        </div>

                                        <div class="text-center py-3">
                                             <a href="{{ route('notifications.index') }}" class="btn btn-primary btn-sm">
                                                  View All Notification <i class="bx bx-right-arrow-alt ms-1"></i>
                                             </a>

                                        </div>
                                   </div>




                                   <!-- User -->
                                   <div class="dropdown topbar-item">
                                        <a type="button" class="topbar-button" id="page-header-user-dropdown" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                             @if(Auth::user()->isOnline())
                                             <span class="badge bg-success">Online</span>
                                             @else
                                             <span class="badge bg-secondary">Offline</span>
                                             @endif
                                             <span class="d-flex align-items-center">
                                                  <img class="rounded-circle" width="32" src="{{asset('assets/images/users/avatar-1.jpg')}}" alt="avatar-3">
                                             </span>
                                        </a>
                                        <div class="dropdown-menu dropdown-menu-end">
                                             <!-- item-->
                                             <h6 class="dropdown-header">Welcome {{ Auth::user()->name }}</h6>
                                             <a class="dropdown-item" href="{{ route('users.view', Auth::user()->id) }}">
                                                  <i class="bx bx-user-circle text-muted fs-18 align-middle me-1"></i><span class="align-middle">Profile</span>
                                             </a>


                                             <div class="dropdown-divider my-1"></div>
                                             <form method="POST" action="{{ route('logout') }}">
                                                  @csrf

                                                  <x-responsive-nav-link :href="route('logout')" class="text-danger"
                                                       onclick="event.preventDefault();
                                        this.closest('form').submit();">
                                                       <i class="bx bx-log-out fs-18 align-middle me-1"></i> {{ __('Log Out') }}
                                                  </x-responsive-nav-link>
                                             </form>

                                        </div>
                                   </div>


                              </div>
                         </div>
                    </div>
          </header>

          <!-- Activity Timeline -->
          <div>
               <div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-activity-offcanvas" style="max-width: 450px; width: 100%;">
                    <div class="d-flex align-items-center bg-primary p-3 offcanvas-header">
                         <h5 class="text-white m-0 fw-semibold">Activity Stream</h5>
                         <button type="button" class="btn-close btn-close-white ms-auto" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                    </div>

                    <div class="offcanvas-body p-0">
                         <div data-simplebar class="h-100 p-4">
                              <div class="position-relative ms-2">
                                   <span class="position-absolute start-0  top-0 border border-dashed h-100"></span>
                                   <div class="position-relative ps-4">
                                        <div class="mb-4">
                                             <span class="position-absolute start-0 avatar-sm translate-middle-x bg-danger d-inline-flex align-items-center justify-content-center rounded-circle text-light fs-20"><iconify-icon icon="iconamoon:folder-check-duotone"></iconify-icon></span>
                                             <div class="ms-2">
                                                  <h5 class="mb-1 text-dark fw-semibold fs-15 lh-base">Report-Fix / Update </h5>
                                                  <p class="d-flex align-items-center">Add 3 files to <span class=" d-flex align-items-center text-primary ms-1"><iconify-icon icon="iconamoon:file-light"></iconify-icon> Tasks</span></p>
                                                  <div class="bg-light bg-opacity-50 rounded-2 p-2">
                                                       <div class="row">
                                                            <div class="col-lg-6 border-end border-light">
                                                                 <div class="d-flex align-items-center gap-2">
                                                                      <i class="bx bxl-figma fs-20 text-red"></i>
                                                                      <a href="#!" class="text-dark fw-medium">Concept.fig</a>
                                                                 </div>
                                                            </div>
                                                            <div class="col-lg-6">
                                                                 <div class="d-flex align-items-center gap-2">
                                                                      <i class="bx bxl-file-doc fs-20 text-success"></i>
                                                                      <a href="#!" class="text-dark fw-medium">larkon.docs</a>
                                                                 </div>
                                                            </div>
                                                       </div>
                                                  </div>
                                                  <h6 class="mt-2 text-muted">Monday , 4:24 PM</h6>
                                             </div>
                                        </div>
                                   </div>
                                   <div class="position-relative ps-4">
                                        <div class="mb-4">
                                             <span class="position-absolute start-0 avatar-sm translate-middle-x bg-success d-inline-flex align-items-center justify-content-center rounded-circle text-light fs-20"><iconify-icon icon="iconamoon:check-circle-1-duotone"></iconify-icon></span>
                                             <div class="ms-2">
                                                  <h5 class="mb-1 text-dark fw-semibold fs-15 lh-base">Project Status
                                                  </h5>
                                                  <p class="d-flex align-items-center mb-0">Marked<span class=" d-flex align-items-center text-primary mx-1"><iconify-icon icon="iconamoon:file-light"></iconify-icon> Design </span> as <span class="badge bg-success-subtle text-success px-2 py-1 ms-1"> Completed</span></p>
                                                  <div class="d-flex align-items-center gap-3 mt-1 bg-light bg-opacity-50 p-2 rounded-2">
                                                       <a href="#!" class="fw-medium text-dark">UI/UX Figma Design</a>
                                                       <div class="ms-auto">
                                                            <a href="#!" class="fw-medium text-primary fs-18" data-bs-toggle="tooltip" data-bs-title="Download" data-bs-placement="bottom"><iconify-icon icon="iconamoon:cloud-download-duotone"></iconify-icon></a>
                                                       </div>
                                                  </div>
                                                  <h6 class="mt-3 text-muted">Monday , 3:00 PM</h6>
                                             </div>
                                        </div>
                                   </div>
                                   <div class="position-relative ps-4">
                                        <div class="mb-4">
                                             <span class="position-absolute start-0 avatar-sm translate-middle-x bg-primary d-inline-flex align-items-center justify-content-center rounded-circle text-light fs-16">UI</span>
                                             <div class="ms-2">
                                                  <h5 class="mb-1 text-dark fw-semibold fs-15">Larkon Application UI v2.0.0 <span class="badge bg-primary-subtle text-primary px-2 py-1 ms-1"> Latest</span>
                                                  </h5>
                                                  <p>Get access to over 20+ pages including a dashboard layout, charts, kanban board, calendar, and pre-order E-commerce & Marketing pages.</p>
                                                  <div class="mt-2">
                                                       <a href="#!" class="btn btn-light btn-sm">Download Zip</a>
                                                  </div>
                                                  <h6 class="mt-3 text-muted">Monday , 2:10 PM</h6>
                                             </div>
                                        </div>
                                   </div>
                                   <div class="position-relative ps-4">
                                        <div class="mb-4">
                                             <span class="position-absolute start-0 translate-middle-x bg-success bg-gradient d-inline-flex align-items-center justify-content-center rounded-circle text-light fs-20"><img src="assets/images/users/avatar-7.jpg" alt="avatar-5" class="avatar-sm rounded-circle"></span>
                                             <div class="ms-2">
                                                  <h5 class="mb-0 text-dark fw-semibold fs-15 lh-base">Alex Smith Attached Photos
                                                  </h5>
                                                  <div class="row g-2 mt-2">
                                                       <div class="col-lg-4">
                                                            <a href="#!">
                                                                 <img src="assets/images/small/img-6.jpg" alt="" class="img-fluid rounded">
                                                            </a>
                                                       </div>
                                                       <div class="col-lg-4">
                                                            <a href="#!">
                                                                 <img src="assets/images/small/img-3.jpg" alt="" class="img-fluid rounded">
                                                            </a>
                                                       </div>
                                                       <div class="col-lg-4">
                                                            <a href="#!">
                                                                 <img src="assets/images/small/img-4.jpg" alt="" class="img-fluid rounded">
                                                            </a>
                                                       </div>
                                                  </div>
                                                  <h6 class="mt-3 text-muted">Monday 1:00 PM</h6>
                                             </div>
                                        </div>
                                   </div>
                                   <div class="position-relative ps-4">
                                        <div class="mb-4">
                                             <span class="position-absolute start-0 translate-middle-x bg-success bg-gradient d-inline-flex align-items-center justify-content-center rounded-circle text-light fs-20"><img src="{{asset('assets/images/users/avatar-6.jpg')}}" alt="avatar-5" class="avatar-sm rounded-circle"></span>
                                             <div class="ms-2">
                                                  <h5 class="mb-0 text-dark fw-semibold fs-15 lh-base">Rebecca J. added a new team member
                                                  </h5>
                                                  <p class="d-flex align-items-center gap-1"><iconify-icon icon="iconamoon:check-circle-1-duotone" class="text-success"></iconify-icon> Added a new member to Front Dashboard</p>
                                                  <h6 class="mt-3 text-muted">Monday 10:00 AM</h6>
                                             </div>
                                        </div>
                                   </div>
                                   <div class="position-relative ps-4">
                                        <div class="mb-4">
                                             <span class="position-absolute start-0 avatar-sm translate-middle-x bg-warning d-inline-flex align-items-center justify-content-center rounded-circle text-light fs-20"><iconify-icon icon="iconamoon:certificate-badge-duotone"></iconify-icon></span>
                                             <div class="ms-2">
                                                  <h5 class="mb-0 text-dark fw-semibold fs-15 lh-base">Achievements
                                                  </h5>
                                                  <p class="d-flex align-items-center gap-1 mt-1">Earned a <iconify-icon icon="iconamoon:certificate-badge-duotone" class="text-danger fs-20"></iconify-icon>" Best Product Award"</p>
                                                  <h6 class="mt-3 text-muted">Monday 9:30 AM</h6>
                                             </div>
                                        </div>
                                   </div>
                              </div>
                              <a href="#!" class="btn btn-outline-dark w-100">View All</a>
                         </div>
                    </div>
               </div>
          </div>

          <!-- Right Sidebar (Theme Settings) -->
          <div>
               <div class="offcanvas offcanvas-end border-0" tabindex="-1" id="theme-settings-offcanvas">
                    <div class="d-flex align-items-center bg-primary p-3 offcanvas-header">
                         <h5 class="text-white m-0">Theme Settings</h5>
                         <button type="button" class="btn-close btn-close-white ms-auto" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                    </div>

                    <div class="offcanvas-body p-0">
                         <div data-simplebar class="h-100">
                              <div class="p-3 settings-bar">

                                   <div>
                                        <h5 class="mb-3 font-16 fw-semibold">Color Scheme</h5>

                                        <div class="form-check mb-2">
                                             <input class="form-check-input" type="radio" name="data-bs-theme" id="layout-color-light" value="light">
                                             <label class="form-check-label" for="layout-color-light">Light</label>
                                        </div>

                                        <div class="form-check mb-2">
                                             <input class="form-check-input" type="radio" name="data-bs-theme" id="layout-color-dark" value="dark">
                                             <label class="form-check-label" for="layout-color-dark">Dark</label>
                                        </div>
                                   </div>

                                   <div>
                                        <h5 class="my-3 font-16 fw-semibold">Topbar Color</h5>

                                        <div class="form-check mb-2">
                                             <input class="form-check-input" type="radio" name="data-topbar-color" id="topbar-color-light" value="light">
                                             <label class="form-check-label" for="topbar-color-light">Light</label>
                                        </div>
                                        <div class="form-check mb-2">
                                             <input class="form-check-input" type="radio" name="data-topbar-color" id="topbar-color-dark" value="dark">
                                             <label class="form-check-label" for="topbar-color-dark">Dark</label>
                                        </div>
                                   </div>


                                   <div>
                                        <h5 class="my-3 font-16 fw-semibold">Menu Color</h5>

                                        <div class="form-check mb-2">
                                             <input class="form-check-input" type="radio" name="data-menu-color" id="leftbar-color-light" value="light">
                                             <label class="form-check-label" for="leftbar-color-light">
                                                  Light
                                             </label>
                                        </div>

                                        <div class="form-check mb-2">
                                             <input class="form-check-input" type="radio" name="data-menu-color" id="leftbar-color-dark" value="dark">
                                             <label class="form-check-label" for="leftbar-color-dark">
                                                  Dark
                                             </label>
                                        </div>
                                   </div>

                                   <div>
                                        <h5 class="my-3 font-16 fw-semibold">Sidebar Size</h5>

                                        <div class="form-check mb-2">
                                             <input class="form-check-input" type="radio" name="data-menu-size" id="leftbar-size-default" value="default">
                                             <label class="form-check-label" for="leftbar-size-default">
                                                  Default
                                             </label>
                                        </div>

                                        <div class="form-check mb-2">
                                             <input class="form-check-input" type="radio" name="data-menu-size" id="leftbar-size-small" value="condensed">
                                             <label class="form-check-label" for="leftbar-size-small">
                                                  Condensed
                                             </label>
                                        </div>

                                        <div class="form-check mb-2">
                                             <input class="form-check-input" type="radio" name="data-menu-size" id="leftbar-hidden" value="hidden">
                                             <label class="form-check-label" for="leftbar-hidden">
                                                  Hidden
                                             </label>
                                        </div>

                                        <div class="form-check mb-2">
                                             <input class="form-check-input" type="radio" name="data-menu-size" id="leftbar-size-small-hover-active" value="sm-hover-active">
                                             <label class="form-check-label" for="leftbar-size-small-hover-active">
                                                  Small Hover Active
                                             </label>
                                        </div>

                                        <div class="form-check mb-2">
                                             <input class="form-check-input" type="radio" name="data-menu-size" id="leftbar-size-small-hover" value="sm-hover">
                                             <label class="form-check-label" for="leftbar-size-small-hover">
                                                  Small Hover
                                             </label>
                                        </div>
                                   </div>

                              </div>
                         </div>
                    </div>
                    <div class="offcanvas-footer border-top p-3 text-center">
                         <div class="row">
                              <div class="col">
                                   <button type="button" class="btn btn-danger w-100" id="reset-layout">Reset</button>
                              </div>
                         </div>
                    </div>
               </div>
          </div>
          <!-- ========== Topbar End ========== -->

          <!-- ========== App Menu Start ========== -->
          <div class="main-nav">
               <!-- Sidebar Logo -->
               <div class="logo-box">
                    <a href="index-2.html" class="logo-dark">
                         <img src="{{asset('assets/images/logo-sm.png')}}" class="logo-sm" alt="logo sm">
                         <img src="{{asset('assets/images/logo-light.png')}}" class="logo-lg" alt="logo dark">
                    </a>

                    <a href="index-2.html" class="logo-light">
                         <img src="{{asset('assets/images/logo-sm.png')}}" class="logo-sm" alt="logo sm">
                         <img src="{{asset('assets/images/logo-light.png')}}" class="logo-lg" alt="logo light">
                    </a>
               </div>

               <!-- Menu Toggle Button (sm-hover) -->
               <button type="button" class="button-sm-hover" aria-label="Show Full Sidebar">
                    <iconify-icon icon="solar:double-alt-arrow-right-bold-duotone" class="button-sm-hover-icon"></iconify-icon>
               </button>

               <div class="scrollbar" data-simplebar>
                    <ul class="navbar-nav" id="navbar-nav">

                         <li class="menu-title">General</li>

                         <li class="nav-item">
                              <a class="nav-link" href="{{route('dashboard')}}">
                                   <span class="nav-icon"><iconify-icon icon="solar:widget-5-bold-duotone"></iconify-icon></span>
                                   <span class="nav-text">Dashboard</span>
                              </a>
                         </li>

                         {{-- MASTER DATA --}}
                         @canany(['room.index','departments','tag.index','category.index','subcategory','brand.index','locations'])
                         <li class="nav-item">
                              <a class="nav-link menu-arrow" href="#sidebarMasters" data-bs-toggle="collapse">
                                   <span class="nav-icon"><iconify-icon icon="solar:layers-bold-duotone"></iconify-icon></span>
                                   <span class="nav-text">Masters</span>
                              </a>

                              <div class="collapse" id="sidebarMasters">
                                   <ul class="nav sub-navbar-nav">

                                        @canany(['room.index'])
                                        <li class="sub-nav-item"><a class="sub-nav-link" href="{{ route('room.index') }}">Rooms</a></li>
                                        @endcanany

                                        @can('departments')
                                        <li class="sub-nav-item"><a class="sub-nav-link" href="{{ route('departments') }}">Departments</a></li>
                                        @endcan

                                        @canany(['tag.index'])
                                        <li class="sub-nav-item"><a class="sub-nav-link" href="{{ route('tag.index') }}">Tags</a></li>
                                        @endcanany

                                        @canany(['category.index'])
                                        <li class="sub-nav-item"><a class="sub-nav-link" href="{{ route('category.index') }}">Category</a></li>
                                        @endcanany

                                        @canany(['subcategory'])
                                        <li class="sub-nav-item"><a class="sub-nav-link" href="{{ route('subcategory') }}">Sub Category</a></li>
                                        @endcanany

                                        @can('brand.index')
                                        <li class="sub-nav-item"><a class="sub-nav-link" href="{{ route('brand.index') }}">Brands</a></li>
                                        @endcan

                                        @canany(['locations'])
                                        <li class="sub-nav-item"><a class="sub-nav-link" href="{{ route('locations') }}">Locations</a></li>
                                        @endcanany

                                   </ul>
                              </div>
                         </li>
                         @endcanany

                         {{-- PRODUCTS --}}
                         @canany(['products','stock.index'])
                         <li class="nav-item">
                              <a class="nav-link menu-arrow" href="#sidebarProducts" data-bs-toggle="collapse">
                                   <span class="nav-icon"><iconify-icon icon="solar:gift-bold-duotone"></iconify-icon></span>
                                   <span class="nav-text">Products</span>
                              </a>

                              <div class="collapse" id="sidebarProducts">
                                   <ul class="nav sub-navbar-nav">

                                        @canany(['products'])
                                        <li class="sub-nav-item"><a class="sub-nav-link" href="{{ route('products') }}">Products</a></li>
                                        @endcanany

                                        @canany(['stock.index'])
                                        <li class="sub-nav-item"><a class="sub-nav-link" href="{{ route('stock.index') }}">Stock & Inventory</a></li>
                                        @endcanany

                                   </ul>
                              </div>
                         </li>
                         @endcanany

                         {{-- ORDERS & PROJECTS --}}
                         @canany(['orders.index','order-returns'])
                         <li class="nav-item">
                              <a class="nav-link menu-arrow" href="#sidebarOrders" data-bs-toggle="collapse">
                                   <span class="nav-icon"><iconify-icon icon="solar:cart-bold-duotone"></iconify-icon></span>
                                   <span class="nav-text">Orders & Projects</span>
                              </a>

                              <div class="collapse" id="sidebarOrders">
                                   <ul class="nav sub-navbar-nav">

                                        @can('orders.index')
                                        <li class="sub-nav-item"><a class="sub-nav-link" href="{{ route('orders.index') }}">Orders</a></li>
                                        @endcan
                                        @can('order-returns')
                                        <li class="sub-nav-item"><a class="sub-nav-link" href="{{ route('order-returns') }}">Order Returns</a></li>
                                        @endcan
                                      
                                   </ul>
                              </div>
                         </li>
                         @endcanany
  @canany(['quotations.index','projects.index'])
                         <li class="nav-item">
                              <a class="nav-link menu-arrow" href="#sidebarProjects" data-bs-toggle="collapse">
                                   <span class="nav-icon"><iconify-icon icon="solar:buildings-bold-duotone"></iconify-icon></span>
                                   <span class="nav-text">Projects & Quotation</span>
                              </a>

                              <div class="collapse" id="sidebarProjects">
                                   <ul class="nav sub-navbar-nav">
                                         @can('projects.index')
                                        <li class="sub-nav-item"><a class="sub-nav-link" href="{{ route('projects.index') }}">Projects</a></li>
                                        @endcan
                                        @can('quotations.index')
                                        <li class="sub-nav-item"><a class="sub-nav-link" href="{{ route('quotations.index') }}">Quotations</a></li>
                                        @endcan 
                                   </ul>
                              </div>
                         </li>
                         @endcanany
                         {{-- MARKETING --}}
                         @canany(['banner','coupons'])
                         <li class="nav-item">
                              <a class="nav-link menu-arrow" href="#sidebarMarketing" data-bs-toggle="collapse">
                                   <span class="nav-icon"><iconify-icon icon="solar:ticket-bold-duotone"></iconify-icon></span>
                                   <span class="nav-text">Marketing</span>
                              </a>

                              <div class="collapse" id="sidebarMarketing">
                                   <ul class="nav sub-navbar-nav">

                                        @canany(['banner'])
                                        <li class="sub-nav-item"><a class="sub-nav-link" href="{{ route('banner') }}">Banner</a></li>
                                        @endcanany

                                        @canany(['coupons'])
                                        <li class="sub-nav-item"><a class="sub-nav-link" href="{{ route('coupons') }}">Coupons</a></li>
                                        @endcanany

                                   </ul>
                              </div>
                         </li>
                         @endcanany

                         {{-- USERS --}}
                         @canany(['roles.index','users.index'])
                         <li class="nav-item">
                              <a class="nav-link menu-arrow" href="#sidebarUsers" data-bs-toggle="collapse">
                                   <span class="nav-icon"><iconify-icon icon="solar:user-bold-duotone"></iconify-icon></span>
                                   <span class="nav-text">Users</span>
                              </a>

                              <div class="collapse" id="sidebarUsers">
                                   <ul class="nav sub-navbar-nav">

                                        @can('roles.index')
                                        <li class="sub-nav-item"><a class="sub-nav-link" href="{{ route('roles.index') }}">Roles & Permissions</a></li>
                                        @endcan

                                        @can('users.index')
                                        <li class="sub-nav-item"><a class="sub-nav-link" href="{{ route('users.index') }}">Users</a></li>
                                        @endcanany

                                   </ul>
                              </div>
                         </li>
                         @endcanany

                         {{-- BUSINESS --}}
                         @canany(['business.requests'])
                         <li class="nav-item">
                              <a class="nav-link" href="{{ route('business.requests') }}">
                                   <span class="nav-icon"><iconify-icon icon="solar:users-group-rounded-bold-duotone"></iconify-icon></span>
                                   <span class="nav-text">Change Role Requests</span>
                              </a>
                         </li>
                         @endcanany
 @canany(['wholesale-enquiry'])
                         <li class="nav-item">
                              <a class="nav-link" href="{{ route('wholesale-enquiry') }}">
                                   <span class="nav-icon"><iconify-icon icon="solar:document-text-bold-duotone"></iconify-icon>

</span>
                                   <span class="nav-text">Wholesale Enquiry</span>
                              </a>
                         </li>
                         @endcanany

                         {{-- LOGISTICS --}}
                         @canany(['courierservice'])
                         <li class="nav-item">
                              <a class="nav-link" href="{{ route('courierservice') }}">
                                   <span class="nav-icon"><iconify-icon icon="solar:delivery-bold-duotone"></iconify-icon></span>
                                   <span class="nav-text">Courier Service</span>
                              </a>
                         </li>
                         @endcanany

                         {{-- SETTINGS --}}
                         @can('settings')
                         <li class="nav-item">
                              <a class="nav-link" href="{{ route('settings') }}">
                                   <span class="nav-icon"><iconify-icon icon="solar:settings-bold-duotone"></iconify-icon></span>
                                   <span class="nav-text">Settings</span>
                              </a>
                         </li>
                         @endcan

                    </ul>
               </div>

          </div>
          <!-- ========== App Menu End ========== -->