@extends('admin.layout.template')
@section('title', 'Change Role')
@section('content')

<div class="page-content">
    <div class="container-xxl">

      
    <div class="card">
        <div class="card-header">
            <h4 class="card-title">Business Role Change Requests</h4>
        </div>

        <div class="card-body">

            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            <div class="table-responsive">
                <table class="table table-bordered table-striped align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>User</th>
                            <th>Email</th>
                            <th>Business Type</th>
                            <th>Legal Shop Name</th>
                            <th>Address</th>
                            <th>Mobile</th>
                            <th>GST</th>
                            <th>Status</th>
                            <th width="180">Action</th>
                        </tr>
                    </thead>

                    <tbody>

                        @forelse($requests as $index => $request)

                        <tr>
                            <td>{{ $index + 1 }}</td>

                            <td>{{ $request->user->name ?? '-' }}</td>

                            <td>{{ $request->user->email ?? '-' }}</td>

                            <td>
                                <span class="badge bg-info">
                                    {{ ucfirst(str_replace('_',' ', $request->business_type)) }}
                                </span>
                            </td>

                            <td>{{ $request->legal_shop_name }}</td>

                            <td>{{ $request->legal_shop_address ?? '-' }}</td>

                            <td>{{ $request->shop_mobile_number ?? '-' }}</td>

                            <td>{{ $request->gst_number ?? '-' }}</td>

                            <td>
                                @if($request->approval_status == 'pending')
                                    <span class="badge bg-warning">Pending</span>
                                @elseif($request->approval_status == 'approved')
                                    <span class="badge bg-success">Approved</span>
                                @else
                                    <span class="badge bg-danger">Rejected</span>
                                @endif
                            </td>

                            <td>

                                @if($request->approval_status == 'pending')

                                    {{-- APPROVE --}}
                                    <form action="{{ route('business.approve', $request->id) }}"
                                          method="POST"
                                          style="display:inline-block">
                                        @csrf
                                        <button class="btn btn-success btn-sm">
                                            Approve
                                        </button>
                                    </form>

                                    {{-- REJECT --}}
                                    <form action="{{ route('business.reject', $request->id) }}"
                                          method="POST"
                                          style="display:inline-block">
                                        @csrf
                                        <button class="btn btn-danger btn-sm">
                                            Reject
                                        </button>
                                    </form>

                                @else
                                    <span class="text-muted">No Action</span>
                                @endif

                            </td>

                        </tr>

                        @empty
                        <tr>
                            <td colspan="10" class="text-center">
                                No Requests Found
                            </td>
                        </tr>
                        @endforelse

                    </tbody>
                </table>
            </div>

        </div>
    </div>

    </div>
</div>

@endsection