<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('coupons', function (Blueprint $table) {

            // 🔹 Discount limits
            $table->decimal('max_discount_amount', 10, 2)
                  ->nullable()
                  ->after('value')
                  ->comment('Maximum discount cap');

            // 🔹 User restrictions
            $table->json('allowed_roles')
                  ->nullable()
                  ->after('category_id')
                  ->comment('B2C, B2B, Franchise, Architect');

            $table->boolean('first_time_user_only')
                  ->default(false)
                  ->after('allowed_roles');

            // 🔹 Usage tracking
            $table->integer('remaining_uses')
                  ->nullable()
                  ->after('used_count');

            $table->timestamp('last_used_at')
                  ->nullable()
                  ->after('remaining_uses');

            // 🔹 Stackability rules
            $table->boolean('is_stackable')
                  ->default(false)
                  ->after('is_active');

            $table->boolean('auto_apply')
                  ->default(false)
                  ->after('is_stackable');

            // 🔹 Analytics
            $table->decimal('total_discount_given', 12, 2)
                  ->default(0)
                  ->after('auto_apply');

            $table->decimal('revenue_generated', 12, 2)
                  ->default(0)
                  ->after('total_discount_given');

            $table->integer('conversion_count')
                  ->default(0)
                  ->after('revenue_generated');

            // 🔹 Referral coupons
            $table->boolean('is_referral')
                  ->default(false)
                  ->after('conversion_count');

            $table->foreignId('referrer_user_id')
                  ->nullable()
                  ->after('is_referral')
                  ->constrained('users')
                  ->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('coupons', function (Blueprint $table) {
            $table->dropColumn([
                'max_discount_amount',
                'allowed_roles',
                'first_time_user_only',
                'remaining_uses',
                'last_used_at',
                'is_stackable',
                'auto_apply',
                'total_discount_given',
                'revenue_generated',
                'conversion_count',
                'is_referral',
                'referrer_user_id',
            ]);
        });
    }
};
