<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up()
    {
        Schema::table('orders', function (Blueprint $table) {

            // 1️⃣ Drop old foreign key
            if (Schema::hasColumn('orders', 'project_id')) {
                $table->dropForeign(['project_id']);
                $table->dropColumn('project_id');
            }

            // 2️⃣ Add quotation_id
            $table->unsignedBigInteger('quotation_id')
                  ->nullable()
                  ->after('user_id');

            // 3️⃣ Add foreign key
            $table->foreign('quotation_id')
                  ->references('id')
                  ->on('quotations')
                  ->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::table('orders', function (Blueprint $table) {

            $table->dropForeign(['quotation_id']);
            $table->dropColumn('quotation_id');

            // Recreate project_id if rollback
            $table->unsignedBigInteger('project_id')
                  ->nullable()
                  ->after('user_id');

            $table->foreign('project_id')
                  ->references('id')
                  ->on('projects')
                  ->onDelete('cascade');
        });
    }
};
