<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;
return new class extends Migration
{
    /**
     * Run the migrations.
     */
public function up()
{
    Schema::table('quotation_items', function (Blueprint $table) {
        $table->unsignedBigInteger('area_id')->nullable()->after('quotation_id');
    });

    // IMPORTANT: Clean invalid data before adding foreign key
    DB::statement("
        UPDATE quotation_items 
        SET area_id = NULL 
        WHERE area_id IS NOT NULL 
        AND area_id NOT IN (SELECT id FROM quotation_areas)
    ");

    Schema::table('quotation_items', function (Blueprint $table) {
        $table->foreign('area_id')
              ->references('id')
              ->on('quotation_areas')
              ->onDelete('cascade');
    });
}

public function down()
{
    Schema::table('quotation_items', function (Blueprint $table) {
        $table->dropForeign(['area_id']);
        $table->dropColumn('area_id');
    });
}
};
