<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quotation_item_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('quotation_item_id');
            $table->json('measurement')->nullable();
            $table->json('details')->nullable();
            $table->timestamps();

            $table->foreign('quotation_item_id')->references('id')->on('quotation_items')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quotation_item_details');
    }
};
