<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('projects', function (Blueprint $table) {
            $table->id();
            $table->string('project_number')->nullable();
            $table->string('project_name');
            $table->foreignId('customer_id')->nullable()->constrained('users')->nullOnDelete();

            $table->string('customer_name');
            $table->string('customer_phone')->nullable();
            
            $table->text('address')->nullable();
            $table->decimal('location_lat', 10, 7)->nullable();
            $table->decimal('location_lng', 10, 7)->nullable();

            $table->enum('project_type', ['home', 'villa', 'flat', 'commercial'])->nullable();

            $table->foreignId('dealer_id')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('architect_id')->nullable()->constrained('users')->nullOnDelete();

            $table->enum('status', [
                'new',
                'measuring',
                'quoted',
                'approved',
                'production',
                'completed'
            ])->default('new');

            $table->date('expected_completion_date')->nullable();
            $table->string('employee_name')->nullable();
            $table->string('employee_contact')->nullable();

            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('projects');
    }
};
